/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.request;

import android.graphics.Bitmap;
import java.io.InputStream;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.util.Utils;

public class Result {
    private final LoadedFrom loadedFrom;
    private final Bitmap bitmap;
    private final InputStream stream;
    private final int exifOrientation;

    Result(Bitmap bitmap, LoadedFrom loadedFrom) {
        this(Utils.checkNotNull(bitmap, "bitmap == null"), null, loadedFrom, 0);
    }

    Result(InputStream stream, LoadedFrom loadedFrom) {
        this(null, Utils.checkNotNull(stream, "stream == null"), loadedFrom, 0);
    }

    Result(Bitmap bitmap, InputStream stream, LoadedFrom loadedFrom, int exifOrientation) {
        if (bitmap != null == (stream != null)) {
            throw new AssertionError();
        }
        this.bitmap = bitmap;
        this.stream = stream;
        this.loadedFrom = Utils.checkNotNull(loadedFrom, "loadedFrom == null");
        this.exifOrientation = exifOrientation;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public LoadedFrom getLoadedFrom() {
        return this.loadedFrom;
    }

    public int getExifOrientation() {
        return this.exifOrientation;
    }
}

