/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.request;

import java.io.IOException;
import java.io.InputStream;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.bean.NetworkResponse;
import site.hanschen.easyloader.downloader.Downloader;
import site.hanschen.easyloader.request.Request;
import site.hanschen.easyloader.request.RequestHandler;
import site.hanschen.easyloader.request.Result;

public class NetworkRequestHandler
extends RequestHandler {
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private final Downloader downloader;

    public NetworkRequestHandler(Downloader downloader) {
        this.downloader = downloader;
    }

    @Override
    public boolean canHandleRequest(Request request) {
        if (request != null && request.uri != null) {
            String scheme = request.uri.getScheme();
            return SCHEME_HTTP.equals(scheme) || SCHEME_HTTPS.equals(scheme);
        }
        return false;
    }

    @Override
    public Result handle(Request request) throws IOException {
        NetworkResponse response = this.downloader.load(request.uri);
        InputStream is = response.getInputStream();
        if (is != null) {
            return new Result(is, LoadedFrom.NETWORK);
        }
        return null;
    }
}

