/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.request;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.MediaStore;
import java.io.IOException;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.request.ContentStreamRequestHandler;
import site.hanschen.easyloader.request.Request;
import site.hanschen.easyloader.request.Result;
import site.hanschen.easyloader.util.BitmapUtils;

public class MediaStoreRequestHandler
extends ContentStreamRequestHandler {
    private static final String[] CONTENT_ORIENTATION = new String[]{"orientation"};

    public MediaStoreRequestHandler(Context context) {
        super(context);
    }

    @Override
    public boolean canHandleRequest(Request request) {
        if (request == null || request.uri == null) {
            return false;
        }
        Uri uri = request.uri;
        return "content".equals(uri.getScheme()) && "media".equals(uri.getAuthority());
    }

    @Override
    public Result handle(Request request) throws IOException {
        boolean isVideo;
        ContentResolver contentResolver = this.context.getContentResolver();
        int exifOrientation = MediaStoreRequestHandler.getExifOrientation(contentResolver, request.uri);
        String mimeType = contentResolver.getType(request.uri);
        boolean bl = isVideo = mimeType != null && mimeType.startsWith("video/");
        if (request.hasSize()) {
            Bitmap bitmap;
            Kind kind = MediaStoreRequestHandler.getKind(request.targetWidth, request.targetHeight);
            if (!isVideo && kind == Kind.FULL) {
                return new Result(null, this.getInputStream(request), LoadedFrom.DISK, exifOrientation);
            }
            long id = ContentUris.parseId((Uri)request.uri);
            BitmapFactory.Options options = BitmapUtils.createBitmapOptions(request);
            options.inJustDecodeBounds = true;
            BitmapUtils.calculateInSampleSize(request.targetWidth, request.targetHeight, kind.width, kind.height, options, request);
            if (isVideo) {
                int tempKind = kind == Kind.FULL ? 1 : kind.androidKind;
                bitmap = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)id, (int)tempKind, (BitmapFactory.Options)options);
            } else {
                bitmap = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)id, (int)kind.androidKind, (BitmapFactory.Options)options);
            }
            if (bitmap != null) {
                return new Result(bitmap, null, LoadedFrom.DISK, exifOrientation);
            }
        }
        return new Result(null, this.getInputStream(request), LoadedFrom.DISK, exifOrientation);
    }

    private static Kind getKind(int targetWidth, int targetHeight) {
        if (targetWidth <= Kind.MICRO.width && targetHeight <= Kind.MICRO.height) {
            return Kind.MICRO;
        }
        if (targetWidth <= Kind.MINI.width && targetHeight <= Kind.MINI.height) {
            return Kind.MINI;
        }
        return Kind.FULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getExifOrientation(ContentResolver contentResolver, Uri uri) {
        try (Cursor cursor = null;){
            cursor = contentResolver.query(uri, CONTENT_ORIENTATION, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                int n = 0;
                return n;
            }
            int n = cursor.getInt(0);
            return n;
        }
    }

    static enum Kind {
        MICRO(3, 96, 96),
        MINI(1, 512, 384),
        FULL(2, -1, -1);

        final int androidKind;
        final int width;
        final int height;

        private Kind(int androidKind, int width, int height) {
            this.androidKind = androidKind;
            this.width = width;
            this.height = height;
        }
    }
}

