/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.request;

import android.content.Context;
import android.media.ExifInterface;
import android.net.Uri;
import java.io.IOException;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.request.ContentStreamRequestHandler;
import site.hanschen.easyloader.request.Request;
import site.hanschen.easyloader.request.Result;

public class FileRequestHandler
extends ContentStreamRequestHandler {
    public FileRequestHandler(Context context) {
        super(context);
    }

    @Override
    public boolean canHandleRequest(Request request) {
        return request != null && request.uri != null && "file".equals(request.uri.getScheme());
    }

    @Override
    public Result handle(Request request) throws IOException {
        return new Result(null, this.getInputStream(request), LoadedFrom.DISK, FileRequestHandler.getFileExifRotation(request.uri));
    }

    private static int getFileExifRotation(Uri uri) throws IOException {
        ExifInterface exifInterface = new ExifInterface(uri.getPath());
        return exifInterface.getAttributeInt("Orientation", 1);
    }
}

