/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.log;

import android.util.Log;
import site.hanschen.easyloader.log.Logger;

public class EasyLoaderLog {
    private static boolean logEnable = true;
    private static Logger logger = new Logger(){

        @Override
        public void v(String tag, String msg) {
            Log.v((String)tag, (String)msg);
        }

        @Override
        public void d(String tag, String msg) {
            Log.d((String)tag, (String)msg);
        }

        @Override
        public void i(String tag, String msg) {
            Log.i((String)tag, (String)msg);
        }

        @Override
        public void w(String tag, String msg) {
            Log.w((String)tag, (String)msg);
        }

        @Override
        public void e(String tag, String msg) {
            Log.e((String)tag, (String)msg);
        }

        @Override
        public void e(String tag, String msg, Throwable t) {
            Log.e((String)tag, (String)msg, (Throwable)t);
        }

        @Override
        public void wtf(String tag, String msg) {
            Log.wtf((String)tag, (String)msg);
        }
    };

    public static void logger(Logger logger) {
        EasyLoaderLog.logger = logger;
    }

    public static void logEnable(boolean logEnable) {
        EasyLoaderLog.logEnable = logEnable;
    }

    private static String getTag(String tag) {
        return "EasyLoader-" + tag;
    }

    public static void v(String tag, String msg) {
        if (!logEnable) {
            return;
        }
        logger.v(EasyLoaderLog.getTag(tag), msg);
    }

    public static void d(String tag, String msg) {
        if (!logEnable) {
            return;
        }
        logger.d(EasyLoaderLog.getTag(tag), msg);
    }

    public static void i(String tag, String msg) {
        if (!logEnable) {
            return;
        }
        logger.i(EasyLoaderLog.getTag(tag), msg);
    }

    public static void w(String tag, String msg) {
        if (!logEnable) {
            return;
        }
        logger.w(EasyLoaderLog.getTag(tag), msg);
    }

    public static void e(String tag, String msg) {
        if (!logEnable) {
            return;
        }
        logger.e(EasyLoaderLog.getTag(tag), msg);
    }

    public static void e(String tag, String msg, Throwable t) {
        if (!logEnable) {
            return;
        }
        logger.e(EasyLoaderLog.getTag(tag), msg, t);
    }

    public static void wtf(String tag, String msg) {
        if (!logEnable) {
            return;
        }
        logger.wtf(EasyLoaderLog.getTag(tag), msg);
    }
}

