/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.downloader;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import site.hanschen.easyloader.bean.NetworkResponse;
import site.hanschen.easyloader.downloader.Downloader;
import site.hanschen.easyloader.downloader.ResponseException;

public class UrlConnectionDownloader
implements Downloader {
    private final Context context;

    public UrlConnectionDownloader(Context context) {
        this.context = context.getApplicationContext();
    }

    protected HttpURLConnection openConnection(Uri path) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(path.toString()).openConnection();
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(20000);
        return connection;
    }

    @Override
    public NetworkResponse load(@NonNull Uri uri) throws IOException {
        HttpURLConnection connection = this.openConnection(uri);
        int responseCode = connection.getResponseCode();
        if (responseCode >= 300) {
            connection.disconnect();
            throw new ResponseException(responseCode + " " + connection.getResponseMessage(), responseCode);
        }
        long contentLength = connection.getHeaderFieldInt("Content-Length", -1);
        return new NetworkResponse(connection.getInputStream(), contentLength);
    }
}

