/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.downloader;

import android.net.Uri;
import android.support.annotation.NonNull;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import site.hanschen.easyloader.bean.NetworkResponse;
import site.hanschen.easyloader.downloader.Downloader;
import site.hanschen.easyloader.downloader.ResponseException;

public class OkhttpDownloader
implements Downloader {
    static final int DEFAULT_READ_TIMEOUT_SECOND = 20;
    static final int DEFAULT_WRITE_TIMEOUT_SECOND = 20;
    static final int DEFAULT_CONNECT_TIMEOUT_SECOND = 15;
    private final OkHttpClient client = new OkHttpClient();

    public OkhttpDownloader() {
        this.client.setConnectTimeout(15L, TimeUnit.SECONDS);
        this.client.setReadTimeout(20L, TimeUnit.SECONDS);
        this.client.setWriteTimeout(20L, TimeUnit.SECONDS);
    }

    @Override
    public NetworkResponse load(@NonNull Uri uri) throws IOException {
        Request.Builder builder = new Request.Builder().url(uri.toString());
        Response response = this.client.newCall(builder.build()).execute();
        int responseCode = response.code();
        if (responseCode >= 300) {
            response.body().close();
            throw new ResponseException(responseCode + " " + response.message(), responseCode);
        }
        return new NetworkResponse(response.body().byteStream(), response.body().contentLength());
    }
}

