/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import site.hanschen.easyloader.cache.CacheManager;
import site.hanschen.easyloader.cache.SizeCalculator;

public class LruMemoryCache<K, V>
implements CacheManager<K, V> {
    private long maxSize;
    private int hitCount;
    private int missCount;
    private int putCount;
    private int evictionCount;
    private long size;
    private final LinkedHashMap<K, V> map;
    private final SizeCalculator<V> calculator;

    public LruMemoryCache(long maxSize, SizeCalculator<V> calculator) {
        if (maxSize <= 0L || calculator == null) {
            throw new IllegalArgumentException("maxSize <= 0 || calculator == null");
        }
        this.maxSize = maxSize;
        this.map = new LinkedHashMap(0, 0.75f, true);
        this.calculator = calculator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            V mapValue = this.map.get(key);
            if (mapValue != null) {
                ++this.hitCount;
                return mapValue;
            }
            ++this.missCount;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        int addedSize = this.calculator.getSizeOf(value);
        if ((long)addedSize > this.maxSize) {
            return;
        }
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            ++this.putCount;
            this.size += (long)addedSize;
            V previous = this.map.put(key, value);
            if (previous != null) {
                this.size -= (long)this.calculator.getSizeOf(previous);
            }
        }
        this.trimToSize(this.maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        Object previous;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            previous = this.map.remove(key);
            if (previous != null) {
                this.size -= (long)this.calculator.getSizeOf(previous);
            }
        }
        return previous;
    }

    @Override
    public long size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resize(long maxSize) {
        if (maxSize <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            this.maxSize = maxSize;
        }
        this.trimToSize(maxSize);
    }

    @Override
    public long maxSize() {
        return this.maxSize;
    }

    @Override
    public void clear() {
        this.trimToSize(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(long maxSize) {
        while (true) {
            LruMemoryCache lruMemoryCache = this;
            synchronized (lruMemoryCache) {
                if (this.size < 0L || this.map.isEmpty() && this.size != 0L) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.map.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> toEvict = this.map.entrySet().iterator().next();
                K key = toEvict.getKey();
                V value = toEvict.getValue();
                this.map.remove(key);
                this.size -= (long)this.calculator.getSizeOf(value);
                ++this.evictionCount;
            }
        }
    }
}

