/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.action;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import site.hanschen.easyloader.EasyLoader;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.Target;
import site.hanschen.easyloader.action.Action;
import site.hanschen.easyloader.request.Request;

public final class TargetAction
extends Action<Target> {
    public TargetAction(EasyLoader loader, Target target, Request data, int memoryPolicy, int diskPolicy, Drawable errorDrawable, String key, Object tag, int errorResId) {
        super(loader, target, data, memoryPolicy, diskPolicy, errorResId, errorDrawable, key, tag, false);
    }

    @Override
    public void onComplete(Bitmap result, LoadedFrom from) {
        if (result == null) {
            throw new AssertionError((Object)String.format("Attempted to onComplete action with no result!\n%s", this));
        }
        Target target = (Target)this.getTarget();
        if (target != null) {
            target.onBitmapLoaded(result, from);
            if (result.isRecycled()) {
                throw new IllegalStateException("Target callback must not recycle bitmap!");
            }
        }
    }

    @Override
    public void onError() {
        Target target = (Target)this.getTarget();
        if (target != null) {
            if (this.errorResId != 0) {
                target.onBitmapFailed(this.loader.getContext().getResources().getDrawable(this.errorResId));
            } else {
                target.onBitmapFailed(this.errorDrawable);
            }
        }
    }
}

