/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.action;

import android.graphics.Bitmap;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import site.hanschen.easyloader.Callback;
import site.hanschen.easyloader.EasyLoader;
import site.hanschen.easyloader.EnhanceDrawable;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.action.Action;
import site.hanschen.easyloader.request.Request;

public class ImageViewAction
extends Action<ImageView> {
    private Callback callback;

    public ImageViewAction(EasyLoader loader, ImageView imageView, Request data, int memoryPolicy, int diskPolicy, int errorResId, Drawable errorDrawable, String key, Object tag, Callback callback, boolean noFade) {
        super(loader, imageView, data, memoryPolicy, diskPolicy, errorResId, errorDrawable, key, tag, noFade);
        this.callback = callback;
    }

    @Override
    public void onComplete(Bitmap result, LoadedFrom from) {
        if (result == null) {
            throw new AssertionError((Object)String.format("Attempted to onComplete action with no result!\n%s", this));
        }
        ImageView target = (ImageView)this.target.get();
        if (target == null) {
            return;
        }
        EnhanceDrawable.setBitmap(target, this.loader.getContext(), result, from, this.noFade, this.loader.isIndicatorsEnabled());
        if (this.callback != null) {
            this.callback.onSuccess();
        }
    }

    @Override
    public void onError() {
        ImageView target = (ImageView)this.target.get();
        if (target == null) {
            return;
        }
        Drawable placeholder = target.getDrawable();
        if (placeholder instanceof AnimationDrawable) {
            ((AnimationDrawable)placeholder).stop();
        }
        if (this.errorResId != 0) {
            target.setImageResource(this.errorResId);
        } else if (this.errorDrawable != null) {
            target.setImageDrawable(this.errorDrawable);
        }
        if (this.callback != null) {
            this.callback.onError();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.callback != null) {
            this.callback = null;
        }
    }
}

