/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.action;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import site.hanschen.easyloader.EasyLoader;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.Priority;
import site.hanschen.easyloader.request.Request;

public abstract class Action<T> {
    final EasyLoader loader;
    final Request request;
    final WeakReference<T> target;
    final boolean noFade;
    final int memoryPolicy;
    final int diskPolicy;
    final int errorResId;
    final Drawable errorDrawable;
    final String key;
    final Object tag;
    boolean willReplay;
    boolean cancelled;

    Action(EasyLoader loader, T target, Request request, int memoryPolicy, int diskPolicy, int errorResId, Drawable errorDrawable, String key, Object tag, boolean noFade) {
        this.loader = loader;
        this.request = request;
        this.target = target == null ? null : new RequestWeakReference<Object>(target, loader.getReferenceQueue(), this);
        this.memoryPolicy = memoryPolicy;
        this.diskPolicy = diskPolicy;
        this.noFade = noFade;
        this.errorResId = errorResId;
        this.errorDrawable = errorDrawable;
        this.key = key;
        this.tag = tag != null ? tag : this;
    }

    public abstract void onComplete(Bitmap var1, LoadedFrom var2);

    public abstract void onError();

    public void cancel() {
        this.cancelled = true;
    }

    public Request getRequest() {
        return this.request;
    }

    public T getTarget() {
        return this.target == null ? null : (T)this.target.get();
    }

    public String getKey() {
        return this.key;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setWillReplay(boolean willReplay) {
        this.willReplay = willReplay;
    }

    public boolean willReplay() {
        return this.willReplay;
    }

    public int getMemoryPolicy() {
        return this.memoryPolicy;
    }

    public int getDiskPolicy() {
        return this.diskPolicy;
    }

    public EasyLoader getLoader() {
        return this.loader;
    }

    public Priority getPriority() {
        return this.request.priority;
    }

    public Object getTag() {
        return this.tag;
    }

    public static class RequestWeakReference<T>
    extends WeakReference<T> {
        private final Action action;

        RequestWeakReference(T referent, ReferenceQueue<? super T> q, Action action) {
            super(referent, q);
            this.action = action;
        }

        public Action getAction() {
            return this.action;
        }
    }
}

