/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import site.hanschen.easyloader.AdjustableExecutorService;
import site.hanschen.easyloader.BitmapHunter;
import site.hanschen.easyloader.DiskPolicy;
import site.hanschen.easyloader.EasyLoader;
import site.hanschen.easyloader.MemoryPolicy;
import site.hanschen.easyloader.action.Action;
import site.hanschen.easyloader.cache.CacheManager;
import site.hanschen.easyloader.util.Utils;

public class Dispatcher {
    private static final int RETRY_DELAY = 500;
    private static final int AIRPLANE_MODE_ON = 1;
    private static final int AIRPLANE_MODE_OFF = 0;
    static final int REQUEST_SUBMIT = 1;
    static final int REQUEST_CANCEL = 2;
    static final int REQUEST_GCED = 3;
    static final int HUNTER_SUCCESS = 4;
    static final int HUNTER_RETRY = 5;
    static final int HUNTER_DECODE_FAILED = 6;
    static final int HUNTER_DELAY_NEXT_BATCH = 7;
    static final int HUNTER_BATCH_COMPLETE = 8;
    static final int NETWORK_STATE_CHANGE = 9;
    static final int AIRPLANE_MODE_CHANGE = 10;
    static final int TAG_PAUSE = 11;
    static final int TAG_RESUME = 12;
    static final int REQUEST_BATCH_RESUME = 13;
    private static final String DISPATCHER_THREAD_NAME = "Dispatcher";
    private static final int BATCH_DELAY = 200;
    private final DispatcherThread dispatcherThread = new DispatcherThread();
    private final Context context;
    private final AdjustableExecutorService service;
    private final Map<String, BitmapHunter> hunterMap;
    private final Map<Object, Action> failedActions;
    private final Map<Object, Action> pausedActions;
    private final List<BitmapHunter> batch;
    private final Set<Object> pausedTags;
    private final Handler dispatcherHandler;
    private final Handler mainThreadHandler;
    private final CacheManager<String, Bitmap> memoryCache;
    private final CacheManager<String, Bitmap> diskCache;
    private final NetworkBroadcastReceiver receiver;
    private final boolean canScansNetworkChanges;
    private boolean airplaneMode;

    Dispatcher(Context context, AdjustableExecutorService service, Handler mainThreadHandler, CacheManager<String, Bitmap> memoryCache, CacheManager<String, Bitmap> diskCache) {
        this.dispatcherThread.start();
        Utils.flushStackLocalLeaks(this.dispatcherThread.getLooper());
        this.dispatcherHandler = new DispatcherHandler(this.dispatcherThread.getLooper(), this);
        this.context = context;
        this.service = service;
        this.hunterMap = new LinkedHashMap<String, BitmapHunter>();
        this.failedActions = new WeakHashMap<Object, Action>();
        this.pausedActions = new WeakHashMap<Object, Action>();
        this.pausedTags = new HashSet<Object>();
        this.mainThreadHandler = mainThreadHandler;
        this.memoryCache = memoryCache;
        this.diskCache = diskCache;
        this.batch = new ArrayList<BitmapHunter>(4);
        this.airplaneMode = Utils.isAirplaneModeOn(this.context);
        this.canScansNetworkChanges = Utils.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE");
        this.receiver = new NetworkBroadcastReceiver(this);
        this.receiver.register();
    }

    void shutdown() {
        this.service.shutdown();
        this.dispatcherThread.quit();
        EasyLoader.HANDLER.post(new Runnable(){

            @Override
            public void run() {
                Dispatcher.this.receiver.unregister();
            }
        });
    }

    void dispatchSubmit(Action action) {
        this.dispatcherHandler.sendMessage(this.dispatcherHandler.obtainMessage(1, (Object)action));
    }

    void dispatchCancel(Action action) {
        this.dispatcherHandler.sendMessage(this.dispatcherHandler.obtainMessage(2, (Object)action));
    }

    void dispatchPauseTag(Object tag) {
        this.dispatcherHandler.sendMessage(this.dispatcherHandler.obtainMessage(11, tag));
    }

    void dispatchResumeTag(Object tag) {
        this.dispatcherHandler.sendMessage(this.dispatcherHandler.obtainMessage(12, tag));
    }

    void dispatchSuccess(BitmapHunter hunter) {
        this.dispatcherHandler.sendMessage(this.dispatcherHandler.obtainMessage(4, (Object)hunter));
    }

    void dispatchRetry(BitmapHunter hunter) {
        this.dispatcherHandler.sendMessageDelayed(this.dispatcherHandler.obtainMessage(5, (Object)hunter), 500L);
    }

    void dispatchFailed(BitmapHunter hunter) {
        this.dispatcherHandler.sendMessage(this.dispatcherHandler.obtainMessage(6, (Object)hunter));
    }

    private void dispatchNetworkStateChange(NetworkInfo info) {
        this.dispatcherHandler.sendMessage(this.dispatcherHandler.obtainMessage(9, (Object)info));
    }

    private void dispatchAirplaneModeChange(boolean airplaneMode) {
        this.dispatcherHandler.sendMessage(this.dispatcherHandler.obtainMessage(10, airplaneMode ? 1 : 0, 0));
    }

    private void performSubmit(Action action) {
        this.performSubmit(action, true);
    }

    private void performSubmit(Action action, boolean dismissFailed) {
        if (this.pausedTags.contains(action.getTag())) {
            this.pausedActions.put(action.getTarget(), action);
            return;
        }
        BitmapHunter hunter = this.hunterMap.get(action.getKey());
        if (hunter != null) {
            hunter.attach(action);
            return;
        }
        if (this.service.isShutdown()) {
            return;
        }
        hunter = BitmapHunter.forRequest(action.getLoader(), this, this.memoryCache, this.diskCache, action);
        hunter.setFuture(this.service.submit(hunter));
        this.hunterMap.put(action.getKey(), hunter);
        if (dismissFailed) {
            this.failedActions.remove(action.getTarget());
        }
    }

    private void performCancel(Action action) {
        String key = action.getKey();
        BitmapHunter hunter = this.hunterMap.get(key);
        if (hunter != null) {
            hunter.detach(action);
            if (hunter.cancel()) {
                this.hunterMap.remove(key);
            }
        }
        if (this.pausedTags.contains(action.getTag())) {
            this.pausedActions.remove(action.getTarget());
        }
        this.failedActions.remove(action.getTarget());
    }

    private void performPauseTag(Object tag) {
        if (!this.pausedTags.add(tag)) {
            return;
        }
        Iterator<BitmapHunter> it = this.hunterMap.values().iterator();
        while (it.hasNext()) {
            boolean hasMultiple;
            BitmapHunter hunter = it.next();
            Action single = hunter.getAction();
            List<Action> joined = hunter.getActions();
            boolean bl = hasMultiple = joined != null && !joined.isEmpty();
            if (single == null && !hasMultiple) continue;
            if (single != null && single.getTag().equals(tag)) {
                hunter.detach(single);
                this.pausedActions.put(single.getTarget(), single);
            }
            if (hasMultiple) {
                for (int i = joined.size() - 1; i >= 0; --i) {
                    Action action = joined.get(i);
                    if (!action.getTag().equals(tag)) continue;
                    hunter.detach(action);
                    this.pausedActions.put(action.getTarget(), action);
                }
            }
            if (!hunter.cancel()) continue;
            it.remove();
        }
    }

    private void performResumeTag(Object tag) {
        if (!this.pausedTags.remove(tag)) {
            return;
        }
        ArrayList<Action> batch = null;
        Iterator<Action> i = this.pausedActions.values().iterator();
        while (i.hasNext()) {
            Action action = i.next();
            if (!action.getTag().equals(tag)) continue;
            if (batch == null) {
                batch = new ArrayList<Action>();
            }
            batch.add(action);
            i.remove();
        }
        if (batch != null) {
            this.mainThreadHandler.sendMessage(this.mainThreadHandler.obtainMessage(13, batch));
        }
    }

    private void performRetry(BitmapHunter hunter) {
        if (hunter.isCancelled()) {
            return;
        }
        if (this.service.isShutdown()) {
            this.performError(hunter, false);
            return;
        }
        NetworkInfo networkInfo = null;
        if (this.canScansNetworkChanges) {
            ConnectivityManager connectivityManager = (ConnectivityManager)Utils.getService(this.context, "connectivity");
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        boolean hasConnectivity = networkInfo != null && networkInfo.isConnected();
        boolean supportsReplay = hunter.supportsReplay();
        boolean shouldRetryHunter = hunter.shouldRetry(this.airplaneMode, networkInfo);
        if (!shouldRetryHunter) {
            boolean willReplay = this.canScansNetworkChanges && supportsReplay;
            this.performError(hunter, willReplay);
            if (willReplay) {
                this.markForReplay(hunter);
            }
            return;
        }
        if (!this.canScansNetworkChanges || hasConnectivity) {
            hunter.setFuture(this.service.submit(hunter));
            return;
        }
        this.performError(hunter, supportsReplay);
        if (supportsReplay) {
            this.markForReplay(hunter);
        }
    }

    private void performSuccess(BitmapHunter hunter) {
        if (MemoryPolicy.shouldWriteToMemoryCache(hunter.getMemoryPolicy())) {
            this.memoryCache.put(hunter.getKey(), hunter.getResult());
        }
        if (DiskPolicy.shouldWriteToDiskCache(hunter.getDiskPolicy())) {
            this.diskCache.put(hunter.getKey(), hunter.getResult());
        }
        this.hunterMap.remove(hunter.getKey());
        this.batch(hunter);
    }

    private void performBatchComplete() {
        ArrayList<BitmapHunter> copy = new ArrayList<BitmapHunter>(this.batch);
        this.batch.clear();
        this.mainThreadHandler.sendMessage(this.mainThreadHandler.obtainMessage(8, copy));
    }

    private void performError(BitmapHunter hunter, boolean willReplay) {
        this.hunterMap.remove(hunter.getKey());
        this.batch(hunter);
    }

    private void performAirplaneModeChange(boolean airplaneMode) {
        this.airplaneMode = airplaneMode;
    }

    private void performNetworkStateChange(NetworkInfo info) {
        this.service.adjustThreadCount(info);
        if (info != null && info.isConnected()) {
            this.flushFailedActions();
        }
    }

    private void flushFailedActions() {
        if (!this.failedActions.isEmpty()) {
            Iterator<Action> iterator = this.failedActions.values().iterator();
            while (iterator.hasNext()) {
                Action action = iterator.next();
                iterator.remove();
                this.performSubmit(action, false);
            }
        }
    }

    private void markForReplay(BitmapHunter hunter) {
        List<Action> joined;
        Action action = hunter.getAction();
        if (action != null) {
            this.markForReplay(action);
        }
        if ((joined = hunter.getActions()) != null) {
            int n = joined.size();
            for (int i = 0; i < n; ++i) {
                Action join = joined.get(i);
                this.markForReplay(join);
            }
        }
    }

    private void markForReplay(Action action) {
        Object target = action.getTarget();
        if (target != null) {
            action.setWillReplay(true);
            this.failedActions.put(target, action);
        }
    }

    private void batch(BitmapHunter hunter) {
        if (hunter.isCancelled()) {
            return;
        }
        this.batch.add(hunter);
        if (!this.dispatcherHandler.hasMessages(7)) {
            this.dispatcherHandler.sendEmptyMessageDelayed(7, 200L);
        }
    }

    static class NetworkBroadcastReceiver
    extends BroadcastReceiver {
        static final String EXTRA_AIRPLANE_STATE = "state";
        private final Dispatcher dispatcher;

        NetworkBroadcastReceiver(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        void register() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.AIRPLANE_MODE");
            if (this.dispatcher.canScansNetworkChanges) {
                filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            }
            this.dispatcher.context.registerReceiver((BroadcastReceiver)this, filter);
        }

        void unregister() {
            this.dispatcher.context.unregisterReceiver((BroadcastReceiver)this);
        }

        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            String action = intent.getAction();
            if ("android.intent.action.AIRPLANE_MODE".equals(action)) {
                if (!intent.hasExtra(EXTRA_AIRPLANE_STATE)) {
                    return;
                }
                this.dispatcher.dispatchAirplaneModeChange(intent.getBooleanExtra(EXTRA_AIRPLANE_STATE, false));
            } else if ("android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
                ConnectivityManager connectivityManager = (ConnectivityManager)Utils.getService(context, "connectivity");
                this.dispatcher.dispatchNetworkStateChange(connectivityManager.getActiveNetworkInfo());
            }
        }
    }

    private static class DispatcherThread
    extends HandlerThread {
        DispatcherThread() {
            super("EasyLoader-Dispatcher", 10);
        }
    }

    private static class DispatcherHandler
    extends Handler {
        private final Dispatcher dispatcher;

        DispatcherHandler(Looper looper, Dispatcher dispatcher) {
            super(looper);
            this.dispatcher = dispatcher;
        }

        public void handleMessage(final Message msg) {
            switch (msg.what) {
                case 1: {
                    Action action = (Action)msg.obj;
                    this.dispatcher.performSubmit(action);
                    break;
                }
                case 2: {
                    Action action = (Action)msg.obj;
                    this.dispatcher.performCancel(action);
                    break;
                }
                case 11: {
                    Object tag = msg.obj;
                    this.dispatcher.performPauseTag(tag);
                    break;
                }
                case 12: {
                    Object tag = msg.obj;
                    this.dispatcher.performResumeTag(tag);
                    break;
                }
                case 4: {
                    BitmapHunter hunter = (BitmapHunter)msg.obj;
                    this.dispatcher.performSuccess(hunter);
                    break;
                }
                case 5: {
                    BitmapHunter hunter = (BitmapHunter)msg.obj;
                    this.dispatcher.performRetry(hunter);
                    break;
                }
                case 6: {
                    BitmapHunter hunter = (BitmapHunter)msg.obj;
                    this.dispatcher.performError(hunter, false);
                    break;
                }
                case 7: {
                    this.dispatcher.performBatchComplete();
                    break;
                }
                case 9: {
                    NetworkInfo info = (NetworkInfo)msg.obj;
                    this.dispatcher.performNetworkStateChange(info);
                    break;
                }
                case 10: {
                    this.dispatcher.performAirplaneModeChange(msg.arg1 == 1);
                    break;
                }
                default: {
                    EasyLoader.HANDLER.post(new Runnable(){

                        @Override
                        public void run() {
                            throw new AssertionError((Object)("Unknown dispatcherHandler message received: " + msg.what));
                        }
                    });
                }
            }
        }
    }
}

