/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader;

import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import java.lang.ref.WeakReference;
import site.hanschen.easyloader.Callback;
import site.hanschen.easyloader.request.RequestCreator;

public class DeferredRequestCreator
implements ViewTreeObserver.OnPreDrawListener {
    final RequestCreator creator;
    final WeakReference<ImageView> target;
    Object attachListener;
    Callback callback;

    public DeferredRequestCreator(RequestCreator creator, ImageView target) {
        this(creator, target, null);
    }

    public DeferredRequestCreator(RequestCreator creator, ImageView target, Callback callback) {
        this.creator = creator;
        this.target = new WeakReference<ImageView>(target);
        this.callback = callback;
        if (Build.VERSION.SDK_INT >= 12 && target.getWindowToken() == null) {
            this.attachListener = HoneycombMr1ViewUtil.defer((View)target, this);
        } else {
            target.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
    }

    public boolean onPreDraw() {
        ImageView target = (ImageView)this.target.get();
        if (target == null) {
            return true;
        }
        ViewTreeObserver vto = target.getViewTreeObserver();
        if (!vto.isAlive()) {
            return true;
        }
        int width = target.getWidth();
        int height = target.getHeight();
        if (width <= 0 || height <= 0 || target.isLayoutRequested()) {
            return true;
        }
        vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.target.clear();
        this.creator.unfit().resize(width, height).into(target, this.callback);
        return true;
    }

    void cancel() {
        this.creator.clearTag();
        this.callback = null;
        ImageView target = (ImageView)this.target.get();
        if (target == null) {
            return;
        }
        this.target.clear();
        if (this.attachListener != null) {
            HoneycombMr1ViewUtil.cancel((View)target, this.attachListener);
            this.attachListener = null;
        } else {
            ViewTreeObserver vto = target.getViewTreeObserver();
            if (!vto.isAlive()) {
                return;
            }
            vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
    }

    Object getTag() {
        return this.creator.getTag();
    }

    static class HoneycombMr1ViewUtil {
        HoneycombMr1ViewUtil() {
        }

        static Object defer(View view, final DeferredRequestCreator creator) {
            View.OnAttachStateChangeListener listener = new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View view) {
                    view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    view.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)creator);
                    creator.attachListener = null;
                }

                public void onViewDetachedFromWindow(View view) {
                }
            };
            view.addOnAttachStateChangeListener(listener);
            return listener;
        }

        static void cancel(View view, Object attachListener) {
            view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)attachListener);
        }
    }
}

