/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader;

import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import site.hanschen.easyloader.BitmapHunter;
import site.hanschen.easyloader.Priority;
import site.hanschen.easyloader.QueueProcessType;
import site.hanschen.easyloader.log.EasyLoaderLog;
import site.hanschen.easyloader.util.Utils;

class AdjustableExecutorService
extends ThreadPoolExecutor {
    private static final int DEFAULT_THREAD_COUNT = 3;

    AdjustableExecutorService() {
        super(3, 3, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), new Utils.ThreadFactory());
    }

    void adjustThreadCount(NetworkInfo info) {
        this.setThreadCount(this.getThreadCount(info));
    }

    private void setThreadCount(int threadCount) {
        EasyLoaderLog.d("ThreadPoolExecutor", "setThreadCount: " + threadCount);
        if (Build.VERSION.SDK_INT > 23) {
            this.setMaximumPoolSize(threadCount);
            this.setCorePoolSize(threadCount);
        } else {
            this.setCorePoolSize(threadCount);
            this.setMaximumPoolSize(threadCount);
        }
    }

    private int getThreadCount(NetworkInfo info) {
        if (info == null || !info.isConnectedOrConnecting()) {
            return 3;
        }
        switch (info.getType()) {
            case 1: 
            case 6: 
            case 9: {
                return 4;
            }
            case 0: {
                switch (info.getSubtype()) {
                    case 13: 
                    case 14: 
                    case 15: {
                        return 3;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 12: {
                        return 2;
                    }
                    case 1: 
                    case 2: {
                        return 1;
                    }
                }
                return 3;
            }
        }
        return 3;
    }

    @Override
    @NonNull
    public Future<?> submit(Runnable task) {
        PriorityFutureTask futureTask = new PriorityFutureTask((BitmapHunter)task);
        this.execute(futureTask);
        return futureTask;
    }

    private static final class PriorityFutureTask
    extends FutureTask<BitmapHunter>
    implements Comparable<PriorityFutureTask> {
        private final BitmapHunter hunter;

        PriorityFutureTask(BitmapHunter hunter) {
            super(hunter, null);
            this.hunter = hunter;
        }

        @Override
        public int compareTo(PriorityFutureTask another) {
            Priority other;
            Priority own = this.hunter.getPriority();
            if (own == (other = another.hunter.getPriority())) {
                if (this.hunter.getLoader().getQueueProcessType() == QueueProcessType.FIFO) {
                    return this.hunter.getSequence() - another.hunter.getSequence();
                }
                return another.hunter.getSequence() - this.hunter.getSequence();
            }
            return other.ordinal() - own.ordinal();
        }
    }
}

