/*
 * Decompiled with CFR 0.152.
 */
package sh.bourbon.gist_firebase;

import com.google.firebase.inappmessaging.FirebaseInAppMessagingDisplay;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingDisplayCallbacks;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.BannerMessage;
import com.google.firebase.inappmessaging.model.Button;
import com.google.firebase.inappmessaging.model.CardMessage;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.ModalMessage;
import com.google.firebase.inappmessaging.model.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import sh.bourbon.gist.data.model.Message;
import sh.bourbon.gist.presentation.GistListener;
import sh.bourbon.gist.presentation.GistSdk;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u001a\u0010\u0015\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lsh/bourbon/gist_firebase/GistFirebaseInAppMessagingDisplay;", "Lcom/google/firebase/inappmessaging/FirebaseInAppMessagingDisplay;", "Lsh/bourbon/gist/presentation/GistListener;", "()V", "currentCallbacks", "Lcom/google/firebase/inappmessaging/FirebaseInAppMessagingDisplayCallbacks;", "messageId", "", "cleanUp", "", "displayMessage", "message", "Lcom/google/firebase/inappmessaging/model/InAppMessage;", "callbacks", "onAction", "currentRoute", "action", "onError", "Lsh/bourbon/gist/data/model/Message;", "onMessageDismissed", "onMessageShown", "tryShowMessageForNullableRoute", "gist-firebase_release"})
public final class GistFirebaseInAppMessagingDisplay
implements FirebaseInAppMessagingDisplay,
GistListener {
    private String messageId;
    private FirebaseInAppMessagingDisplayCallbacks currentCallbacks;

    public void displayMessage(@NotNull InAppMessage message, @NotNull FirebaseInAppMessagingDisplayCallbacks callbacks) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)callbacks, (String)"callbacks");
        InAppMessage inAppMessage = message;
        if (inAppMessage instanceof BannerMessage) {
            Text text = ((BannerMessage)message).getTitle();
            Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"message.title");
            this.tryShowMessageForNullableRoute(text.getText(), callbacks);
        } else if (inAppMessage instanceof CardMessage) {
            Text text = ((CardMessage)message).getTitle();
            Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"message.title");
            this.tryShowMessageForNullableRoute(text.getText(), callbacks);
        } else if (inAppMessage instanceof ModalMessage) {
            Text text = ((ModalMessage)message).getTitle();
            Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"message.title");
            this.tryShowMessageForNullableRoute(text.getText(), callbacks);
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)callbacks.impressionDetected(), (String)"callbacks.impressionDetected()");
        }
    }

    public void onMessageShown(@NotNull Message message) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            if (!Intrinsics.areEqual((Object)message.getMessageId(), (Object)this.messageId)) break block1;
            FirebaseInAppMessagingDisplayCallbacks firebaseInAppMessagingDisplayCallbacks = this.currentCallbacks;
            if (firebaseInAppMessagingDisplayCallbacks != null) {
                firebaseInAppMessagingDisplayCallbacks.impressionDetected();
            }
        }
    }

    public void onMessageDismissed(@NotNull Message message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (Intrinsics.areEqual((Object)message.getMessageId(), (Object)this.messageId)) {
            FirebaseInAppMessagingDisplayCallbacks firebaseInAppMessagingDisplayCallbacks = this.currentCallbacks;
            if (firebaseInAppMessagingDisplayCallbacks != null) {
                firebaseInAppMessagingDisplayCallbacks.messageDismissed(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType.CLICK);
            }
            this.cleanUp();
        }
    }

    public void onAction(@NotNull String currentRoute, @NotNull String action) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)currentRoute, (String)"currentRoute");
            Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
            Text text = Text.builder().setText(action).setHexColor("#000000").build();
            Button button = Button.builder().setText(text).setButtonHexColor("#FFFFFF").build();
            Action inAppMessagingAction = Action.builder().setButton(button).build();
            FirebaseInAppMessagingDisplayCallbacks firebaseInAppMessagingDisplayCallbacks = this.currentCallbacks;
            if (firebaseInAppMessagingDisplayCallbacks == null) break block0;
            firebaseInAppMessagingDisplayCallbacks.messageClicked(inAppMessagingAction);
        }
    }

    public void onError(@NotNull Message message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.cleanUp();
    }

    private final void tryShowMessageForNullableRoute(String messageId, FirebaseInAppMessagingDisplayCallbacks callbacks) {
        if (messageId != null) {
            this.messageId = messageId;
            this.currentCallbacks = callbacks;
            GistSdk.INSTANCE.showMessage(new Message(messageId, null, null, 6, null));
        }
    }

    private final void cleanUp() {
        this.currentCallbacks = null;
        this.messageId = null;
    }

    public GistFirebaseInAppMessagingDisplay() {
        GistSdk.INSTANCE.addListener((GistListener)this);
    }
}

