/*
 * Decompiled with CFR 0.152.
 */
package sh.bourbon.gist_firebase;

import com.google.firebase.inappmessaging.FirebaseInAppMessagingDisplay;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingDisplayCallbacks;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.BannerMessage;
import com.google.firebase.inappmessaging.model.Button;
import com.google.firebase.inappmessaging.model.CardMessage;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.ModalMessage;
import com.google.firebase.inappmessaging.model.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import sh.bourbon.gist.presentation.GistListener;
import sh.bourbon.gist.presentation.GistSdk;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u001a\u0010\u0015\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lsh/bourbon/gist_firebase/GistFirebaseInAppMessagingDisplay;", "Lcom/google/firebase/inappmessaging/FirebaseInAppMessagingDisplay;", "Lsh/bourbon/gist/presentation/GistListener;", "()V", "currentCallbacks", "Lcom/google/firebase/inappmessaging/FirebaseInAppMessagingDisplayCallbacks;", "currentMessageRoute", "", "cleanUp", "", "displayMessage", "message", "Lcom/google/firebase/inappmessaging/model/InAppMessage;", "callbacks", "onAction", "currentRoute", "action", "onError", "messageRoute", "onMessageDismissed", "onMessageShown", "tryShowMessageForNullableRoute", "gist-firebase_release"})
public final class GistFirebaseInAppMessagingDisplay
implements FirebaseInAppMessagingDisplay,
GistListener {
    private String currentMessageRoute;
    private FirebaseInAppMessagingDisplayCallbacks currentCallbacks;

    public void displayMessage(@NotNull InAppMessage message, @NotNull FirebaseInAppMessagingDisplayCallbacks callbacks) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)callbacks, (String)"callbacks");
        InAppMessage inAppMessage = message;
        if (inAppMessage instanceof BannerMessage) {
            Text text = ((BannerMessage)message).getTitle();
            Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"message.title");
            this.tryShowMessageForNullableRoute(text.getText(), callbacks);
        } else if (inAppMessage instanceof CardMessage) {
            Text text = ((CardMessage)message).getTitle();
            Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"message.title");
            this.tryShowMessageForNullableRoute(text.getText(), callbacks);
        } else if (inAppMessage instanceof ModalMessage) {
            Text text = ((ModalMessage)message).getTitle();
            Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"message.title");
            this.tryShowMessageForNullableRoute(text.getText(), callbacks);
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)callbacks.impressionDetected(), (String)"callbacks.impressionDetected()");
        }
    }

    public void onMessageShown(@NotNull String messageRoute) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)messageRoute, (String)"messageRoute");
            if (!Intrinsics.areEqual((Object)messageRoute, (Object)this.currentMessageRoute)) break block1;
            FirebaseInAppMessagingDisplayCallbacks firebaseInAppMessagingDisplayCallbacks = this.currentCallbacks;
            if (firebaseInAppMessagingDisplayCallbacks != null) {
                firebaseInAppMessagingDisplayCallbacks.impressionDetected();
            }
        }
    }

    public void onMessageDismissed(@NotNull String messageRoute) {
        Intrinsics.checkParameterIsNotNull((Object)messageRoute, (String)"messageRoute");
        if (Intrinsics.areEqual((Object)messageRoute, (Object)this.currentMessageRoute)) {
            FirebaseInAppMessagingDisplayCallbacks firebaseInAppMessagingDisplayCallbacks = this.currentCallbacks;
            if (firebaseInAppMessagingDisplayCallbacks != null) {
                firebaseInAppMessagingDisplayCallbacks.messageDismissed(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType.CLICK);
            }
            this.cleanUp();
        }
    }

    public void onAction(@NotNull String currentRoute, @NotNull String action) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)currentRoute, (String)"currentRoute");
            Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
            Text text = Text.builder().setText(action).setHexColor("#000000").build();
            Button button = Button.builder().setText(text).setButtonHexColor("#FFFFFF").build();
            Action inAppMessagingAction = Action.builder().setButton(button).build();
            FirebaseInAppMessagingDisplayCallbacks firebaseInAppMessagingDisplayCallbacks = this.currentCallbacks;
            if (firebaseInAppMessagingDisplayCallbacks == null) break block0;
            firebaseInAppMessagingDisplayCallbacks.messageClicked(inAppMessagingAction);
        }
    }

    public void onError(@NotNull String messageRoute) {
        Intrinsics.checkParameterIsNotNull((Object)messageRoute, (String)"messageRoute");
        this.cleanUp();
    }

    private final void tryShowMessageForNullableRoute(String messageRoute, FirebaseInAppMessagingDisplayCallbacks callbacks) {
        if (messageRoute != null) {
            this.currentMessageRoute = messageRoute;
            this.currentCallbacks = callbacks;
            GistSdk.INSTANCE.showMessage(messageRoute);
        }
    }

    private final void cleanUp() {
        this.currentCallbacks = null;
        this.currentMessageRoute = null;
    }

    public GistFirebaseInAppMessagingDisplay() {
        GistSdk.INSTANCE.addListener((GistListener)this);
    }
}

