/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.localization;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.LocaleList;
import androidx.annotation.NonNull;
import io.flutter.embedding.engine.systemchannels.LocalizationChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LocalizationPlugin {
    @NonNull
    private final LocalizationChannel localizationChannel;
    @NonNull
    private final Context context;

    public LocalizationPlugin(@NonNull Context context, @NonNull LocalizationChannel localizationChannel) {
        this.context = context;
        this.localizationChannel = localizationChannel;
    }

    public Locale resolveNativeLocale(List<Locale> supportedLocales) {
        if (supportedLocales == null || supportedLocales.isEmpty()) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            ArrayList<Locale.LanguageRange> languageRanges = new ArrayList<Locale.LanguageRange>();
            LocaleList localeList = this.context.getResources().getConfiguration().getLocales();
            int localeCount = localeList.size();
            for (int index = 0; index < localeCount; ++index) {
                Locale locale = localeList.get(index);
                String localeString = locale.toString();
                languageRanges.add(new Locale.LanguageRange(localeString.replace("_", "-")));
                languageRanges.add(new Locale.LanguageRange(locale.getLanguage()));
                languageRanges.add(new Locale.LanguageRange(locale.getLanguage() + "-*"));
            }
            Locale platformResolvedLocale = Locale.lookup(languageRanges, supportedLocales);
            if (platformResolvedLocale != null) {
                return platformResolvedLocale;
            }
            return supportedLocales.get(0);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = this.context.getResources().getConfiguration().getLocales();
            for (int index = 0; index < localeList.size(); ++index) {
                Locale preferredLocale = localeList.get(index);
                for (Locale locale : supportedLocales) {
                    if (!preferredLocale.equals(locale)) continue;
                    return locale;
                }
                for (Locale locale : supportedLocales) {
                    if (!preferredLocale.getLanguage().equals(locale.toLanguageTag())) continue;
                    return locale;
                }
                for (Locale locale : supportedLocales) {
                    if (!preferredLocale.getLanguage().equals(locale.getLanguage())) continue;
                    return locale;
                }
            }
            return supportedLocales.get(0);
        }
        Locale preferredLocale = this.context.getResources().getConfiguration().locale;
        if (preferredLocale != null) {
            for (Locale locale : supportedLocales) {
                if (!preferredLocale.equals(locale)) continue;
                return locale;
            }
            for (Locale locale : supportedLocales) {
                if (!preferredLocale.getLanguage().equals(locale.toString())) continue;
                return locale;
            }
        }
        return supportedLocales.get(0);
    }

    public void sendLocalesToFlutter(@NonNull Configuration config) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = config.getLocales();
            int localeCount = localeList.size();
            for (int index = 0; index < localeCount; ++index) {
                Locale locale = localeList.get(index);
                locales.add(locale);
            }
        } else {
            locales.add(config.locale);
        }
        this.localizationChannel.sendLocales(locales);
    }
}

