/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.pathprovider;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugins.pathprovider.StorageDirectoryMapper;
import io.flutter.util.PathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PathProviderPlugin
implements FlutterPlugin,
MethodChannel.MethodCallHandler {
    private Context context;
    private MethodChannel channel;

    public static void registerWith(PluginRegistry.Registrar registrar) {
        PathProviderPlugin instance = new PathProviderPlugin();
        instance.channel = new MethodChannel(registrar.messenger(), "plugins.flutter.io/path_provider");
        instance.context = registrar.context();
        instance.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)instance);
    }

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.channel = new MethodChannel(binding.getBinaryMessenger(), "plugins.flutter.io/path_provider");
        this.context = binding.getApplicationContext();
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.channel.setMethodCallHandler(null);
        this.channel = null;
    }

    public void onMethodCall(MethodCall call, @NonNull MethodChannel.Result result) {
        switch (call.method) {
            case "getTemporaryDirectory": {
                result.success((Object)this.getPathProviderTemporaryDirectory());
                break;
            }
            case "getApplicationDocumentsDirectory": {
                result.success((Object)this.getPathProviderApplicationDocumentsDirectory());
                break;
            }
            case "getStorageDirectory": {
                result.success((Object)this.getPathProviderStorageDirectory());
                break;
            }
            case "getExternalCacheDirectories": {
                result.success(this.getPathProviderExternalCacheDirectories());
                break;
            }
            case "getExternalStorageDirectories": {
                Integer type = (Integer)call.argument("type");
                String directoryName = StorageDirectoryMapper.androidType(type);
                result.success(this.getPathProviderExternalStorageDirectories(directoryName));
                break;
            }
            case "getApplicationSupportDirectory": {
                result.success((Object)this.getApplicationSupportDirectory());
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    private String getPathProviderTemporaryDirectory() {
        return this.context.getCacheDir().getPath();
    }

    private String getApplicationSupportDirectory() {
        return PathUtils.getFilesDir((Context)this.context);
    }

    private String getPathProviderApplicationDocumentsDirectory() {
        return PathUtils.getDataDirectory((Context)this.context);
    }

    private String getPathProviderStorageDirectory() {
        File dir = this.context.getExternalFilesDir(null);
        if (dir == null) {
            return null;
        }
        return dir.getAbsolutePath();
    }

    private List<String> getPathProviderExternalCacheDirectories() {
        ArrayList<String> paths = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 19) {
            for (File dir : this.context.getExternalCacheDirs()) {
                if (dir == null) continue;
                paths.add(dir.getAbsolutePath());
            }
        } else {
            File dir = this.context.getExternalCacheDir();
            if (dir != null) {
                paths.add(dir.getAbsolutePath());
            }
        }
        return paths;
    }

    private List<String> getPathProviderExternalStorageDirectories(String type) {
        ArrayList<String> paths = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 19) {
            for (File dir : this.context.getExternalFilesDirs(type)) {
                if (dir == null) continue;
                paths.add(dir.getAbsolutePath());
            }
        } else {
            File dir = this.context.getExternalFilesDir(type);
            if (dir != null) {
                paths.add(dir.getAbsolutePath());
            }
        }
        return paths;
    }
}

