/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import android.util.Log;
import androidx.annotation.UiThread;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodCodec;
import io.flutter.plugin.common.StandardMethodCodec;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class EventChannel {
    private static final String TAG = "EventChannel#";
    private final BinaryMessenger messenger;
    private final String name;
    private final MethodCodec codec;

    public EventChannel(BinaryMessenger messenger, String name) {
        this(messenger, name, StandardMethodCodec.INSTANCE);
    }

    public EventChannel(BinaryMessenger messenger, String name, MethodCodec codec) {
        if (messenger == null) {
            Log.e((String)TAG, (String)"Parameter messenger must not be null.");
        }
        if (name == null) {
            Log.e((String)TAG, (String)"Parameter name must not be null.");
        }
        if (codec == null) {
            Log.e((String)TAG, (String)"Parameter codec must not be null.");
        }
        this.messenger = messenger;
        this.name = name;
        this.codec = codec;
    }

    @UiThread
    public void setStreamHandler(StreamHandler handler) {
        this.messenger.setMessageHandler(this.name, handler == null ? null : new IncomingStreamRequestHandler(handler));
    }

    private final class IncomingStreamRequestHandler
    implements BinaryMessenger.BinaryMessageHandler {
        private final StreamHandler handler;
        private final AtomicReference<EventSink> activeSink = new AtomicReference<Object>(null);

        IncomingStreamRequestHandler(StreamHandler handler) {
            this.handler = handler;
        }

        @Override
        public void onMessage(ByteBuffer message, BinaryMessenger.BinaryReply reply) {
            MethodCall call = EventChannel.this.codec.decodeMethodCall(message);
            if (call.method.equals("listen")) {
                this.onListen(call.arguments, reply);
            } else if (call.method.equals("cancel")) {
                this.onCancel(call.arguments, reply);
            } else {
                reply.reply(null);
            }
        }

        private void onListen(Object arguments, BinaryMessenger.BinaryReply callback) {
            EventSinkImplementation eventSink = new EventSinkImplementation();
            EventSink oldSink = this.activeSink.getAndSet(eventSink);
            if (oldSink != null) {
                try {
                    this.handler.onCancel(null);
                }
                catch (RuntimeException e) {
                    Log.e((String)(EventChannel.TAG + EventChannel.this.name), (String)"Failed to close existing event stream", (Throwable)e);
                }
            }
            try {
                this.handler.onListen(arguments, eventSink);
                callback.reply(EventChannel.this.codec.encodeSuccessEnvelope(null));
            }
            catch (RuntimeException e) {
                this.activeSink.set(null);
                Log.e((String)(EventChannel.TAG + EventChannel.this.name), (String)"Failed to open event stream", (Throwable)e);
                callback.reply(EventChannel.this.codec.encodeErrorEnvelope("error", e.getMessage(), null));
            }
        }

        private void onCancel(Object arguments, BinaryMessenger.BinaryReply callback) {
            EventSink oldSink = this.activeSink.getAndSet(null);
            if (oldSink != null) {
                try {
                    this.handler.onCancel(arguments);
                    callback.reply(EventChannel.this.codec.encodeSuccessEnvelope(null));
                }
                catch (RuntimeException e) {
                    Log.e((String)(EventChannel.TAG + EventChannel.this.name), (String)"Failed to close event stream", (Throwable)e);
                    callback.reply(EventChannel.this.codec.encodeErrorEnvelope("error", e.getMessage(), null));
                }
            } else {
                callback.reply(EventChannel.this.codec.encodeErrorEnvelope("error", "No active stream to cancel", null));
            }
        }

        private final class EventSinkImplementation
        implements EventSink {
            final AtomicBoolean hasEnded = new AtomicBoolean(false);

            private EventSinkImplementation() {
            }

            @Override
            @UiThread
            public void success(Object event) {
                if (this.hasEnded.get() || IncomingStreamRequestHandler.this.activeSink.get() != this) {
                    return;
                }
                EventChannel.this.messenger.send(EventChannel.this.name, EventChannel.this.codec.encodeSuccessEnvelope(event));
            }

            @Override
            @UiThread
            public void error(String errorCode, String errorMessage, Object errorDetails) {
                if (this.hasEnded.get() || IncomingStreamRequestHandler.this.activeSink.get() != this) {
                    return;
                }
                EventChannel.this.messenger.send(EventChannel.this.name, EventChannel.this.codec.encodeErrorEnvelope(errorCode, errorMessage, errorDetails));
            }

            @Override
            @UiThread
            public void endOfStream() {
                if (this.hasEnded.getAndSet(true) || IncomingStreamRequestHandler.this.activeSink.get() != this) {
                    return;
                }
                EventChannel.this.messenger.send(EventChannel.this.name, null);
            }
        }
    }

    public static interface EventSink {
        public void success(Object var1);

        public void error(String var1, String var2, Object var3);

        public void endOfStream();
    }

    public static interface StreamHandler {
        public void onListen(Object var1, EventSink var2);

        public void onCancel(Object var1);
    }
}

