/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.loader;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.loader.ResourceExtractor;
import io.flutter.util.PathUtils;
import io.flutter.view.VsyncWaiter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class FlutterLoader {
    private static final String TAG = "FlutterLoader";
    private static final String AOT_SHARED_LIBRARY_NAME = "aot-shared-library-name";
    private static final String SNAPSHOT_ASSET_PATH_KEY = "snapshot-asset-path";
    private static final String VM_SNAPSHOT_DATA_KEY = "vm-snapshot-data";
    private static final String ISOLATE_SNAPSHOT_DATA_KEY = "isolate-snapshot-data";
    private static final String FLUTTER_ASSETS_DIR_KEY = "flutter-assets-dir";
    private static final String PUBLIC_AOT_SHARED_LIBRARY_NAME = FlutterLoader.class.getName() + '.' + "aot-shared-library-name";
    private static final String PUBLIC_VM_SNAPSHOT_DATA_KEY = FlutterLoader.class.getName() + '.' + "vm-snapshot-data";
    private static final String PUBLIC_ISOLATE_SNAPSHOT_DATA_KEY = FlutterLoader.class.getName() + '.' + "isolate-snapshot-data";
    private static final String PUBLIC_FLUTTER_ASSETS_DIR_KEY = FlutterLoader.class.getName() + '.' + "flutter-assets-dir";
    private static final String DEFAULT_AOT_SHARED_LIBRARY_NAME = "libapp.so";
    private static final String DEFAULT_VM_SNAPSHOT_DATA = "vm_snapshot_data";
    private static final String DEFAULT_ISOLATE_SNAPSHOT_DATA = "isolate_snapshot_data";
    private static final String DEFAULT_LIBRARY = "libflutter.so";
    private static final String DEFAULT_KERNEL_BLOB = "kernel_blob.bin";
    private static final String DEFAULT_FLUTTER_ASSETS_DIR = "flutter_assets";
    private String aotSharedLibraryName = "libapp.so";
    private String vmSnapshotData = "vm_snapshot_data";
    private String isolateSnapshotData = "isolate_snapshot_data";
    private String flutterAssetsDir = "flutter_assets";
    private static FlutterLoader instance;
    private boolean initialized = false;
    @Nullable
    private ResourceExtractor resourceExtractor;
    @Nullable
    private Settings settings;

    @NonNull
    public static FlutterLoader getInstance() {
        if (instance == null) {
            instance = new FlutterLoader();
        }
        return instance;
    }

    public void startInitialization(@NonNull Context applicationContext) {
        this.startInitialization(applicationContext, new Settings());
    }

    public void startInitialization(@NonNull Context applicationContext, @NonNull Settings settings) {
        if (this.settings != null) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("startInitialization must be called on the main thread");
        }
        applicationContext = applicationContext.getApplicationContext();
        this.settings = settings;
        long initStartTimestampMillis = SystemClock.uptimeMillis();
        this.initConfig(applicationContext);
        this.initResources(applicationContext);
        System.loadLibrary("flutter");
        VsyncWaiter.getInstance((WindowManager)applicationContext.getSystemService("window")).init();
        long initTimeMillis = SystemClock.uptimeMillis() - initStartTimestampMillis;
        FlutterJNI.nativeRecordStartTimestamp(initTimeMillis);
    }

    public void ensureInitializationComplete(@NonNull Context applicationContext, @Nullable String[] args) {
        if (this.initialized) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (this.settings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        try {
            if (this.resourceExtractor != null) {
                this.resourceExtractor.waitForCompletion();
            }
            ArrayList<String> shellArgs = new ArrayList<String>();
            shellArgs.add("--icu-symbol-prefix=_binary_icudtl_dat");
            ApplicationInfo applicationInfo = this.getApplicationInfo(applicationContext);
            shellArgs.add("--icu-native-lib-path=" + applicationInfo.nativeLibraryDir + File.separator + DEFAULT_LIBRARY);
            if (args != null) {
                Collections.addAll(shellArgs, args);
            }
            String kernelPath = null;
            String snapshotAssetPath = PathUtils.getDataDirectory(applicationContext) + File.separator + this.flutterAssetsDir;
            kernelPath = snapshotAssetPath + File.separator + DEFAULT_KERNEL_BLOB;
            shellArgs.add("--snapshot-asset-path=" + snapshotAssetPath);
            shellArgs.add("--vm-snapshot-data=" + this.vmSnapshotData);
            shellArgs.add("--isolate-snapshot-data=" + this.isolateSnapshotData);
            shellArgs.add("--cache-dir-path=" + PathUtils.getCacheDirectory(applicationContext));
            if (this.settings.getLogTag() != null) {
                shellArgs.add("--log-tag=" + this.settings.getLogTag());
            }
            String appStoragePath = PathUtils.getFilesDir(applicationContext);
            String engineCachesPath = PathUtils.getCacheDirectory(applicationContext);
            FlutterJNI.nativeInit(applicationContext, shellArgs.toArray(new String[0]), kernelPath, appStoragePath, engineCachesPath);
            this.initialized = true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Flutter initialization failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void ensureInitializationCompleteAsync(final @NonNull Context applicationContext, final @Nullable String[] args, final @NonNull Handler callbackHandler, final @NonNull Runnable callback) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (this.settings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        if (this.initialized) {
            callbackHandler.post(callback);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (FlutterLoader.this.resourceExtractor != null) {
                    FlutterLoader.this.resourceExtractor.waitForCompletion();
                }
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        FlutterLoader.this.ensureInitializationComplete(applicationContext.getApplicationContext(), args);
                        callbackHandler.post(callback);
                    }
                });
            }
        }).start();
    }

    @NonNull
    private ApplicationInfo getApplicationInfo(@NonNull Context applicationContext) {
        try {
            return applicationContext.getPackageManager().getApplicationInfo(applicationContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void initConfig(@NonNull Context applicationContext) {
        Bundle metadata = this.getApplicationInfo((Context)applicationContext).metaData;
        if (metadata == null) {
            return;
        }
        this.aotSharedLibraryName = metadata.getString(PUBLIC_AOT_SHARED_LIBRARY_NAME, DEFAULT_AOT_SHARED_LIBRARY_NAME);
        this.flutterAssetsDir = metadata.getString(PUBLIC_FLUTTER_ASSETS_DIR_KEY, DEFAULT_FLUTTER_ASSETS_DIR);
        this.vmSnapshotData = metadata.getString(PUBLIC_VM_SNAPSHOT_DATA_KEY, DEFAULT_VM_SNAPSHOT_DATA);
        this.isolateSnapshotData = metadata.getString(PUBLIC_ISOLATE_SNAPSHOT_DATA_KEY, DEFAULT_ISOLATE_SNAPSHOT_DATA);
    }

    private void initResources(@NonNull Context applicationContext) {
        String dataDirPath = PathUtils.getDataDirectory(applicationContext);
        String packageName = applicationContext.getPackageName();
        PackageManager packageManager = applicationContext.getPackageManager();
        AssetManager assetManager = applicationContext.getResources().getAssets();
        this.resourceExtractor = new ResourceExtractor(dataDirPath, packageName, packageManager, assetManager);
        this.resourceExtractor.addResource(this.fullAssetPathFrom(this.vmSnapshotData)).addResource(this.fullAssetPathFrom(this.isolateSnapshotData)).addResource(this.fullAssetPathFrom(DEFAULT_KERNEL_BLOB));
        this.resourceExtractor.start();
    }

    @NonNull
    public String findAppBundlePath() {
        return this.flutterAssetsDir;
    }

    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset) {
        return this.fullAssetPathFrom(asset);
    }

    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset, @NonNull String packageName) {
        return this.getLookupKeyForAsset("packages" + File.separator + packageName + File.separator + asset);
    }

    @NonNull
    private String fullAssetPathFrom(@NonNull String filePath) {
        return this.flutterAssetsDir + File.separator + filePath;
    }

    public static class Settings {
        private String logTag;

        @Nullable
        public String getLogTag() {
            return this.logTag;
        }

        public void setLogTag(String tag) {
            this.logTag = tag;
        }
    }
}

