/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.urllauncher;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.Nullable;
import io.flutter.plugins.urllauncher.WebViewActivity;

class UrlLauncher {
    private final Context applicationContext;
    @Nullable
    private Activity activity;

    UrlLauncher(Context applicationContext, @Nullable Activity activity) {
        this.applicationContext = applicationContext;
        this.activity = activity;
    }

    void setActivity(@Nullable Activity activity) {
        this.activity = activity;
    }

    boolean canLaunch(String url) {
        Intent launchIntent = new Intent("android.intent.action.VIEW");
        launchIntent.setData(Uri.parse((String)url));
        ComponentName componentName = launchIntent.resolveActivity(this.applicationContext.getPackageManager());
        return componentName != null && !"{com.android.fallback/com.android.fallback.Fallback}".equals(componentName.toShortString());
    }

    LaunchStatus launch(String url, Bundle headersBundle, boolean useWebView, boolean enableJavaScript, boolean enableDomStorage) {
        if (this.activity == null) {
            return LaunchStatus.NO_ACTIVITY;
        }
        Intent launchIntent = useWebView ? WebViewActivity.createIntent((Context)this.activity, url, enableJavaScript, enableDomStorage, headersBundle) : new Intent("android.intent.action.VIEW").setData(Uri.parse((String)url)).putExtra("com.android.browser.headers", headersBundle);
        this.activity.startActivity(launchIntent);
        return LaunchStatus.OK;
    }

    void closeWebView() {
        this.applicationContext.sendBroadcast(new Intent(WebViewActivity.ACTION_CLOSE));
    }

    static enum LaunchStatus {
        OK,
        NO_ACTIVITY;

    }
}

