/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.urllauncher;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.util.HashMap;
import java.util.Map;

public class WebViewActivity
extends Activity {
    public static String ACTION_CLOSE = "close action";
    private final BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (ACTION_CLOSE.equals(action)) {
                WebViewActivity.this.finish();
            }
        }
    };
    private final WebViewClient webViewClient = new WebViewClient(){

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (Build.VERSION.SDK_INT < 21) {
                view.loadUrl(url);
                return false;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.loadUrl(request.getUrl().toString());
            }
            return false;
        }
    };
    private WebView webview;
    private IntentFilter closeIntentFilter = new IntentFilter(ACTION_CLOSE);
    private static String URL_EXTRA = "url";
    private static String ENABLE_JS_EXTRA = "enableJavaScript";
    private static String ENABLE_DOM_EXTRA = "enableDomStorage";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.webview = new WebView((Context)this);
        this.setContentView((View)this.webview);
        Intent intent = this.getIntent();
        String url = intent.getStringExtra(URL_EXTRA);
        boolean enableJavaScript = intent.getBooleanExtra(ENABLE_JS_EXTRA, false);
        boolean enableDomStorage = intent.getBooleanExtra(ENABLE_DOM_EXTRA, false);
        Bundle headersBundle = intent.getBundleExtra("com.android.browser.headers");
        Map<String, String> headersMap = this.extractHeaders(headersBundle);
        this.webview.loadUrl(url, headersMap);
        this.webview.getSettings().setJavaScriptEnabled(enableJavaScript);
        this.webview.getSettings().setDomStorageEnabled(enableDomStorage);
        this.webview.setWebViewClient(this.webViewClient);
        this.registerReceiver(this.broadcastReceiver, this.closeIntentFilter);
    }

    private Map<String, String> extractHeaders(Bundle headersBundle) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (String key : headersBundle.keySet()) {
            String value = headersBundle.getString(key);
            headersMap.put(key, value);
        }
        return headersMap;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.broadcastReceiver);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.webview.canGoBack()) {
            this.webview.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public static Intent createIntent(Context context, String url, boolean enableJavaScript, boolean enableDomStorage, Bundle headersBundle) {
        return new Intent(context, WebViewActivity.class).putExtra(URL_EXTRA, url).putExtra(ENABLE_JS_EXTRA, enableJavaScript).putExtra(ENABLE_DOM_EXTRA, enableDomStorage).putExtra("com.android.browser.headers", headersBundle);
    }
}

