/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.plugins.shim;

import android.support.annotation.NonNull;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.embedding.engine.plugins.shim.ShimRegistrar;
import io.flutter.plugin.common.PluginRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ShimPluginRegistry
implements PluginRegistry {
    private static final String TAG = "ShimPluginRegistry";
    private final FlutterEngine flutterEngine;
    private final Map<String, Object> pluginMap = new HashMap<String, Object>();
    private final ShimRegistrarAggregate shimRegistrarAggregate;

    public ShimPluginRegistry(@NonNull FlutterEngine flutterEngine) {
        this.flutterEngine = flutterEngine;
        this.shimRegistrarAggregate = new ShimRegistrarAggregate();
        this.flutterEngine.getPlugins().add(this.shimRegistrarAggregate);
    }

    @Override
    public PluginRegistry.Registrar registrarFor(String pluginKey) {
        Log.v(TAG, "Creating plugin Registrar for '" + pluginKey + "'");
        if (this.pluginMap.containsKey(pluginKey)) {
            throw new IllegalStateException("Plugin key " + pluginKey + " is already in use");
        }
        this.pluginMap.put(pluginKey, null);
        ShimRegistrar registrar = new ShimRegistrar(pluginKey, this.pluginMap);
        this.shimRegistrarAggregate.addPlugin(registrar);
        return registrar;
    }

    @Override
    public boolean hasPlugin(String pluginKey) {
        return this.pluginMap.containsKey(pluginKey);
    }

    @Override
    public <T> T valuePublishedByPlugin(String pluginKey) {
        return (T)this.pluginMap.get(pluginKey);
    }

    private static class ShimRegistrarAggregate
    implements FlutterPlugin,
    ActivityAware {
        private final Set<ShimRegistrar> shimRegistrars = new HashSet<ShimRegistrar>();
        private FlutterPlugin.FlutterPluginBinding flutterPluginBinding;
        private ActivityPluginBinding activityPluginBinding;

        private ShimRegistrarAggregate() {
        }

        public void addPlugin(@NonNull ShimRegistrar shimRegistrar) {
            this.shimRegistrars.add(shimRegistrar);
            if (this.flutterPluginBinding != null) {
                shimRegistrar.onAttachedToEngine(this.flutterPluginBinding);
            }
            if (this.activityPluginBinding != null) {
                shimRegistrar.onAttachedToActivity(this.activityPluginBinding);
            }
        }

        @Override
        public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
            this.flutterPluginBinding = binding;
            for (ShimRegistrar shimRegistrar : this.shimRegistrars) {
                shimRegistrar.onAttachedToEngine(binding);
            }
        }

        @Override
        public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
            for (ShimRegistrar shimRegistrar : this.shimRegistrars) {
                shimRegistrar.onDetachedFromEngine(binding);
            }
            this.flutterPluginBinding = null;
            this.activityPluginBinding = null;
        }

        @Override
        public void onAttachedToActivity(@NonNull ActivityPluginBinding binding) {
            this.activityPluginBinding = binding;
            for (ShimRegistrar shimRegistrar : this.shimRegistrars) {
                shimRegistrar.onAttachedToActivity(binding);
            }
        }

        @Override
        public void onDetachedFromActivityForConfigChanges() {
            for (ShimRegistrar shimRegistrar : this.shimRegistrars) {
                shimRegistrar.onDetachedFromActivity();
            }
            this.activityPluginBinding = null;
        }

        @Override
        public void onReattachedToActivityForConfigChanges(@NonNull ActivityPluginBinding binding) {
            this.activityPluginBinding = binding;
            for (ShimRegistrar shimRegistrar : this.shimRegistrars) {
                shimRegistrar.onReattachedToActivityForConfigChanges(binding);
            }
        }

        @Override
        public void onDetachedFromActivity() {
            for (ShimRegistrar shimRegistrar : this.shimRegistrars) {
                shimRegistrar.onDetachedFromActivity();
            }
            this.activityPluginBinding = null;
        }
    }
}

