/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.sharedpreferences;

import android.content.Context;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugins.sharedpreferences.MethodCallHandlerImpl;

public class SharedPreferencesPlugin
implements FlutterPlugin {
    private static final String CHANNEL_NAME = "plugins.flutter.io/shared_preferences";
    private MethodChannel channel;

    public static void registerWith(PluginRegistry.Registrar registrar) {
        SharedPreferencesPlugin plugin = new SharedPreferencesPlugin();
        plugin.setupChannel(registrar.messenger(), registrar.context());
    }

    public void onAttachedToEngine(FlutterPlugin.FlutterPluginBinding binding) {
        this.setupChannel((BinaryMessenger)binding.getFlutterEngine().getDartExecutor(), binding.getApplicationContext());
    }

    public void onDetachedFromEngine(FlutterPlugin.FlutterPluginBinding binding) {
        this.teardownChannel();
    }

    private void setupChannel(BinaryMessenger messenger, Context context) {
        this.channel = new MethodChannel(messenger, CHANNEL_NAME);
        MethodCallHandlerImpl handler = new MethodCallHandlerImpl(context);
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)handler);
    }

    private void teardownChannel() {
        this.channel.setMethodCallHandler(null);
        this.channel = null;
    }
}

