/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.JSONMethodCodec;
import io.flutter.plugin.common.MethodChannel;

public class NavigationChannel {
    private static final String TAG = "NavigationChannel";
    @NonNull
    public final MethodChannel channel;

    public NavigationChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/navigation", JSONMethodCodec.INSTANCE);
    }

    public void setInitialRoute(@NonNull String initialRoute) {
        Log.v(TAG, "Sending message to set initial route to '" + initialRoute + "'");
        this.channel.invokeMethod("setInitialRoute", initialRoute);
    }

    public void pushRoute(@NonNull String route) {
        Log.v(TAG, "Sending message to push route '" + route + "'");
        this.channel.invokeMethod("pushRoute", route);
    }

    public void popRoute() {
        Log.v(TAG, "Sending message to pop route.");
        this.channel.invokeMethod("popRoute", null);
    }

    public void setMethodCallHandler(@Nullable MethodChannel.MethodCallHandler handler) {
        this.channel.setMethodCallHandler(handler);
    }
}

