/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.urllauncher;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugins.urllauncher.UrlLauncher;
import java.util.Map;

final class MethodCallHandlerImpl
implements MethodChannel.MethodCallHandler {
    private static final String TAG = "MethodCallHandlerImpl";
    private final UrlLauncher urlLauncher;
    @Nullable
    private MethodChannel channel;

    MethodCallHandlerImpl(UrlLauncher urlLauncher) {
        this.urlLauncher = urlLauncher;
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        String url = (String)call.argument("url");
        switch (call.method) {
            case "canLaunch": {
                this.onCanLaunch(result, url);
                break;
            }
            case "launch": {
                this.onLaunch(call, result, url);
                break;
            }
            case "closeWebView": {
                this.onCloseWebView(result);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    void startListening(BinaryMessenger messenger) {
        if (this.channel != null) {
            Log.wtf((String)TAG, (String)"Setting a method call handler before the last was disposed.");
            this.stopListening();
        }
        this.channel = new MethodChannel(messenger, "plugins.flutter.io/url_launcher");
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
    }

    void stopListening() {
        if (this.channel == null) {
            Log.d((String)TAG, (String)"Tried to stop listening when no MethodChannel had been initialized.");
            return;
        }
        this.channel.setMethodCallHandler(null);
        this.channel = null;
    }

    private void onCanLaunch(MethodChannel.Result result, String url) {
        result.success((Object)this.urlLauncher.canLaunch(url));
    }

    private void onLaunch(MethodCall call, MethodChannel.Result result, String url) {
        boolean useWebView = (Boolean)call.argument("useWebView");
        boolean enableJavaScript = (Boolean)call.argument("enableJavaScript");
        boolean enableDomStorage = (Boolean)call.argument("enableDomStorage");
        Map headersMap = (Map)call.argument("headers");
        Bundle headersBundle = MethodCallHandlerImpl.extractBundle(headersMap);
        UrlLauncher.LaunchStatus launchStatus = this.urlLauncher.launch(url, headersBundle, useWebView, enableJavaScript, enableDomStorage);
        if (launchStatus == UrlLauncher.LaunchStatus.NO_ACTIVITY) {
            result.error("NO_ACTIVITY", "Launching a URL requires a foreground activity.", null);
        } else {
            result.success((Object)true);
        }
    }

    private void onCloseWebView(MethodChannel.Result result) {
        this.urlLauncher.closeWebView();
        result.success(null);
    }

    private static Bundle extractBundle(Map<String, String> headersMap) {
        Bundle headersBundle = new Bundle();
        for (String key : headersMap.keySet()) {
            String value = headersMap.get(key);
            headersBundle.putString(key, value);
        }
        return headersBundle;
    }
}

