/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.annotation.SuppressLint;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.os.Build;
import android.provider.Settings;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextPaint;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import io.flutter.Log;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;

class InputConnectionAdaptor
extends BaseInputConnection {
    private final View mFlutterView;
    private final int mClient;
    private final TextInputChannel textInputChannel;
    private final Editable mEditable;
    private final EditorInfo mEditorInfo;
    private int mBatchCount;
    private InputMethodManager mImm;
    private final Layout mLayout;
    private final boolean isSamsung;

    public InputConnectionAdaptor(View view, int client, TextInputChannel textInputChannel, Editable editable, EditorInfo editorInfo) {
        super(view, true);
        this.mFlutterView = view;
        this.mClient = client;
        this.textInputChannel = textInputChannel;
        this.mEditable = editable;
        this.mEditorInfo = editorInfo;
        this.mBatchCount = 0;
        this.mLayout = new DynamicLayout((CharSequence)this.mEditable, new TextPaint(), Integer.MAX_VALUE, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        this.mImm = (InputMethodManager)view.getContext().getSystemService("input_method");
        this.isSamsung = this.isSamsung();
    }

    private void updateEditingState() {
        if (this.mBatchCount > 0) {
            return;
        }
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        int composingStart = BaseInputConnection.getComposingSpanStart((Spannable)this.mEditable);
        int composingEnd = BaseInputConnection.getComposingSpanEnd((Spannable)this.mEditable);
        this.mImm.updateSelection(this.mFlutterView, selectionStart, selectionEnd, composingStart, composingEnd);
        this.textInputChannel.updateEditingState(this.mClient, this.mEditable.toString(), selectionStart, selectionEnd, composingStart, composingEnd);
    }

    public Editable getEditable() {
        return this.mEditable;
    }

    public boolean beginBatchEdit() {
        ++this.mBatchCount;
        return super.beginBatchEdit();
    }

    public boolean endBatchEdit() {
        boolean result = super.endBatchEdit();
        --this.mBatchCount;
        this.updateEditingState();
        return result;
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        boolean result = super.commitText(text, newCursorPosition);
        this.updateEditingState();
        return result;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        if (Selection.getSelectionStart((CharSequence)this.mEditable) == -1) {
            return true;
        }
        boolean result = super.deleteSurroundingText(beforeLength, afterLength);
        this.updateEditingState();
        return result;
    }

    public boolean setComposingRegion(int start, int end) {
        boolean result = super.setComposingRegion(start, end);
        this.updateEditingState();
        return result;
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        boolean result = text.length() == 0 ? super.commitText(text, newCursorPosition) : super.setComposingText(text, newCursorPosition);
        this.updateEditingState();
        return result;
    }

    public boolean finishComposingText() {
        boolean result = super.finishComposingText();
        if (this.isSamsung && Build.VERSION.SDK_INT >= 21) {
            CursorAnchorInfo.Builder builder = new CursorAnchorInfo.Builder();
            builder.setComposingText(-1, (CharSequence)"");
            CursorAnchorInfo anchorInfo = builder.build();
            this.mImm.updateCursorAnchorInfo(this.mFlutterView, anchorInfo);
        }
        this.updateEditingState();
        return result;
    }

    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        ExtractedText extractedText = new ExtractedText();
        extractedText.selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        extractedText.selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        extractedText.text = this.mEditable.toString();
        return extractedText;
    }

    @SuppressLint(value={"NewApi"})
    private boolean isSamsung() {
        InputMethodSubtype subtype = this.mImm.getCurrentInputMethodSubtype();
        if (subtype == null || Build.VERSION.SDK_INT < 21 || !Build.MANUFACTURER.equals("samsung")) {
            return false;
        }
        String keyboardName = Settings.Secure.getString((ContentResolver)this.mFlutterView.getContext().getContentResolver(), (String)"default_input_method");
        return keyboardName.contains("Samsung");
    }

    public boolean setSelection(int start, int end) {
        boolean result = super.setSelection(start, end);
        this.updateEditingState();
        return result;
    }

    private static int clampIndexToEditable(int index, Editable editable) {
        int clamped = Math.max(0, Math.min(editable.length(), index));
        if (clamped != index) {
            Log.d("flutter", "Text selection index was clamped (" + index + "->" + clamped + ") to remain in bounds. This may not be your fault, as some keyboards may select outside of bounds.");
        }
        return clamped;
    }

    public boolean sendKeyEvent(KeyEvent event) {
        if (event.getAction() == 0) {
            if (event.getKeyCode() == 67) {
                int selStart = InputConnectionAdaptor.clampIndexToEditable(Selection.getSelectionStart((CharSequence)this.mEditable), this.mEditable);
                int selEnd = InputConnectionAdaptor.clampIndexToEditable(Selection.getSelectionEnd((CharSequence)this.mEditable), this.mEditable);
                if (selEnd > selStart) {
                    Selection.setSelection((Spannable)this.mEditable, (int)selStart);
                    this.mEditable.delete(selStart, selEnd);
                    this.updateEditingState();
                    return true;
                }
                if (selStart > 0) {
                    boolean isRtl = this.mLayout.isRtlCharAt(this.mLayout.getLineForOffset(selStart));
                    try {
                        if (isRtl) {
                            Selection.extendRight((Spannable)this.mEditable, (Layout)this.mLayout);
                        } else {
                            Selection.extendLeft((Spannable)this.mEditable, (Layout)this.mLayout);
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        Selection.setSelection((Spannable)this.mEditable, (int)selStart, (int)(selStart - 1));
                    }
                    int newStart = InputConnectionAdaptor.clampIndexToEditable(Selection.getSelectionStart((CharSequence)this.mEditable), this.mEditable);
                    int newEnd = InputConnectionAdaptor.clampIndexToEditable(Selection.getSelectionEnd((CharSequence)this.mEditable), this.mEditable);
                    Selection.setSelection((Spannable)this.mEditable, (int)Math.min(newStart, newEnd));
                    this.mEditable.delete(Math.min(newStart, newEnd), Math.max(newStart, newEnd));
                    this.updateEditingState();
                    return true;
                }
            } else {
                if (event.getKeyCode() == 21) {
                    int selEnd;
                    int selStart = Selection.getSelectionStart((CharSequence)this.mEditable);
                    if (selStart == (selEnd = Selection.getSelectionEnd((CharSequence)this.mEditable)) && !event.isShiftPressed()) {
                        int newSel = Math.max(selStart - 1, 0);
                        this.setSelection(newSel, newSel);
                    } else {
                        int newSelEnd = Math.max(selEnd - 1, 0);
                        this.setSelection(selStart, newSelEnd);
                    }
                    return true;
                }
                if (event.getKeyCode() == 22) {
                    int selEnd;
                    int selStart = Selection.getSelectionStart((CharSequence)this.mEditable);
                    if (selStart == (selEnd = Selection.getSelectionEnd((CharSequence)this.mEditable)) && !event.isShiftPressed()) {
                        int newSel = Math.min(selStart + 1, this.mEditable.length());
                        this.setSelection(newSel, newSel);
                    } else {
                        int newSelEnd = Math.min(selEnd + 1, this.mEditable.length());
                        this.setSelection(selStart, newSelEnd);
                    }
                    return true;
                }
                if (event.getKeyCode() == 19) {
                    int selEnd;
                    int selStart = Selection.getSelectionStart((CharSequence)this.mEditable);
                    if (selStart == (selEnd = Selection.getSelectionEnd((CharSequence)this.mEditable)) && !event.isShiftPressed()) {
                        Selection.moveUp((Spannable)this.mEditable, (Layout)this.mLayout);
                        int newSelStart = Selection.getSelectionStart((CharSequence)this.mEditable);
                        this.setSelection(newSelStart, newSelStart);
                    } else {
                        Selection.extendUp((Spannable)this.mEditable, (Layout)this.mLayout);
                        int newSelStart = Selection.getSelectionStart((CharSequence)this.mEditable);
                        int newSelEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
                        this.setSelection(newSelStart, newSelEnd);
                    }
                    return true;
                }
                if (event.getKeyCode() == 20) {
                    int selEnd;
                    int selStart = Selection.getSelectionStart((CharSequence)this.mEditable);
                    if (selStart == (selEnd = Selection.getSelectionEnd((CharSequence)this.mEditable)) && !event.isShiftPressed()) {
                        Selection.moveDown((Spannable)this.mEditable, (Layout)this.mLayout);
                        int newSelStart = Selection.getSelectionStart((CharSequence)this.mEditable);
                        this.setSelection(newSelStart, newSelStart);
                    } else {
                        Selection.extendDown((Spannable)this.mEditable, (Layout)this.mLayout);
                        int newSelStart = Selection.getSelectionStart((CharSequence)this.mEditable);
                        int newSelEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
                        this.setSelection(newSelStart, newSelEnd);
                    }
                    return true;
                }
                if ((event.getKeyCode() == 66 || event.getKeyCode() == 160) && (0x20000 & this.mEditorInfo.inputType) == 0) {
                    this.performEditorAction(this.mEditorInfo.imeOptions & 0xFF);
                    return true;
                }
                int character = event.getUnicodeChar();
                if (character != 0) {
                    int selMax;
                    int selEnd;
                    int selStart = Math.max(0, Selection.getSelectionStart((CharSequence)this.mEditable));
                    int selMin = Math.min(selStart, selEnd = Math.max(0, Selection.getSelectionEnd((CharSequence)this.mEditable)));
                    if (selMin != (selMax = Math.max(selStart, selEnd))) {
                        this.mEditable.delete(selMin, selMax);
                    }
                    this.mEditable.insert(selMin, (CharSequence)String.valueOf((char)character));
                    this.setSelection(selMin + 1, selMin + 1);
                }
                return true;
            }
        }
        if (event.getAction() == 1 && (event.getKeyCode() == 59 || event.getKeyCode() == 60)) {
            int selEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
            this.setSelection(selEnd, selEnd);
            return true;
        }
        return false;
    }

    public boolean performContextMenuAction(int id2) {
        if (id2 == 16908319) {
            this.setSelection(0, this.mEditable.length());
            return true;
        }
        if (id2 == 0x1020020) {
            int selEnd;
            int selStart = Selection.getSelectionStart((CharSequence)this.mEditable);
            if (selStart != (selEnd = Selection.getSelectionEnd((CharSequence)this.mEditable))) {
                int selMin = Math.min(selStart, selEnd);
                int selMax = Math.max(selStart, selEnd);
                CharSequence textToCut = this.mEditable.subSequence(selMin, selMax);
                ClipboardManager clipboard = (ClipboardManager)this.mFlutterView.getContext().getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"text label?", (CharSequence)textToCut);
                clipboard.setPrimaryClip(clip);
                this.mEditable.delete(selMin, selMax);
                this.setSelection(selMin, selMin);
            }
            return true;
        }
        if (id2 == 0x1020021) {
            int selEnd;
            int selStart = Selection.getSelectionStart((CharSequence)this.mEditable);
            if (selStart != (selEnd = Selection.getSelectionEnd((CharSequence)this.mEditable))) {
                CharSequence textToCopy = this.mEditable.subSequence(Math.min(selStart, selEnd), Math.max(selStart, selEnd));
                ClipboardManager clipboard = (ClipboardManager)this.mFlutterView.getContext().getSystemService("clipboard");
                clipboard.setPrimaryClip(ClipData.newPlainText((CharSequence)"text label?", (CharSequence)textToCopy));
            }
            return true;
        }
        if (id2 == 0x1020022) {
            ClipboardManager clipboard = (ClipboardManager)this.mFlutterView.getContext().getSystemService("clipboard");
            ClipData clip = clipboard.getPrimaryClip();
            if (clip != null) {
                int selMax;
                int selEnd;
                CharSequence textToPaste = clip.getItemAt(0).coerceToText(this.mFlutterView.getContext());
                int selStart = Math.max(0, Selection.getSelectionStart((CharSequence)this.mEditable));
                int selMin = Math.min(selStart, selEnd = Math.max(0, Selection.getSelectionEnd((CharSequence)this.mEditable)));
                if (selMin != (selMax = Math.max(selStart, selEnd))) {
                    this.mEditable.delete(selMin, selMax);
                }
                this.mEditable.insert(selMin, textToPaste);
                int newSelStart = selMin + textToPaste.length();
                this.setSelection(newSelStart, newSelStart);
            }
            return true;
        }
        return false;
    }

    public boolean performEditorAction(int actionCode) {
        switch (actionCode) {
            case 1: {
                this.textInputChannel.newline(this.mClient);
                break;
            }
            case 0: {
                this.textInputChannel.unspecifiedAction(this.mClient);
                break;
            }
            case 2: {
                this.textInputChannel.go(this.mClient);
                break;
            }
            case 3: {
                this.textInputChannel.search(this.mClient);
                break;
            }
            case 4: {
                this.textInputChannel.send(this.mClient);
                break;
            }
            case 5: {
                this.textInputChannel.next(this.mClient);
                break;
            }
            case 7: {
                this.textInputChannel.previous(this.mClient);
                break;
            }
            default: {
                this.textInputChannel.done(this.mClient);
            }
        }
        return true;
    }
}

