/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.sharedpreferences;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.util.Base64;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MethodCallHandlerImpl
implements MethodChannel.MethodCallHandler {
    private static final String SHARED_PREFERENCES_NAME = "FlutterSharedPreferences";
    private static final String LIST_IDENTIFIER = "VGhpcyBpcyB0aGUgcHJlZml4IGZvciBhIGxpc3Qu";
    private static final String BIG_INTEGER_PREFIX = "VGhpcyBpcyB0aGUgcHJlZml4IGZvciBCaWdJbnRlZ2Vy";
    private static final String DOUBLE_PREFIX = "VGhpcyBpcyB0aGUgcHJlZml4IGZvciBEb3VibGUu";
    private final SharedPreferences preferences;

    MethodCallHandlerImpl(Context context) {
        this.preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        String key = (String)call.argument("key");
        try {
            switch (call.method) {
                case "setBool": {
                    this.commitAsync(this.preferences.edit().putBoolean(key, ((Boolean)call.argument("value")).booleanValue()), result);
                    break;
                }
                case "setDouble": {
                    double doubleValue = ((Number)call.argument("value")).doubleValue();
                    String doubleValueStr = Double.toString(doubleValue);
                    this.commitAsync(this.preferences.edit().putString(key, DOUBLE_PREFIX + doubleValueStr), result);
                    break;
                }
                case "setInt": {
                    Number number = (Number)call.argument("value");
                    if (number instanceof BigInteger) {
                        BigInteger integerValue = (BigInteger)number;
                        this.commitAsync(this.preferences.edit().putString(key, BIG_INTEGER_PREFIX + integerValue.toString(36)), result);
                        break;
                    }
                    this.commitAsync(this.preferences.edit().putLong(key, number.longValue()), result);
                    break;
                }
                case "setString": {
                    String value = (String)call.argument("value");
                    if (value.startsWith(LIST_IDENTIFIER) || value.startsWith(BIG_INTEGER_PREFIX)) {
                        result.error("StorageError", "This string cannot be stored as it clashes with special identifier prefixes.", null);
                        return;
                    }
                    this.commitAsync(this.preferences.edit().putString(key, value), result);
                    break;
                }
                case "setStringList": {
                    List list = (List)call.argument("value");
                    this.commitAsync(this.preferences.edit().putString(key, LIST_IDENTIFIER + this.encodeList(list)), result);
                    break;
                }
                case "commit": {
                    result.success((Object)true);
                    break;
                }
                case "getAll": {
                    result.success(this.getAllPrefs());
                    return;
                }
                case "remove": {
                    this.commitAsync(this.preferences.edit().remove(key), result);
                    break;
                }
                case "clear": {
                    Set<String> keySet = this.getAllPrefs().keySet();
                    SharedPreferences.Editor clearEditor = this.preferences.edit();
                    for (String keyToDelete : keySet) {
                        clearEditor.remove(keyToDelete);
                    }
                    this.commitAsync(clearEditor, result);
                    break;
                }
                default: {
                    result.notImplemented();
                    break;
                }
            }
        }
        catch (IOException e) {
            result.error("IOException encountered", call.method, (Object)e);
        }
    }

    private void commitAsync(final SharedPreferences.Editor editor, final MethodChannel.Result result) {
        new AsyncTask<Void, Void, Boolean>(){

            protected Boolean doInBackground(Void ... voids) {
                return editor.commit();
            }

            protected void onPostExecute(Boolean value) {
                result.success((Object)value);
            }
        }.execute((Object[])new Void[0]);
    }

    private List<String> decodeList(String encodedList) throws IOException {
        try (ObjectInputStream stream = null;){
            stream = new ObjectInputStream(new ByteArrayInputStream(Base64.decode((String)encodedList, (int)0)));
            List list = (List)stream.readObject();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encodeList(List<String> list) throws IOException {
        try (ObjectOutputStream stream = null;){
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(byteStream);
            stream.writeObject(list);
            stream.flush();
            String string = Base64.encodeToString((byte[])byteStream.toByteArray(), (int)0);
            return string;
        }
    }

    private Map<String, Object> getAllPrefs() throws IOException {
        Map allPrefs = this.preferences.getAll();
        HashMap<String, Object> filteredPrefs = new HashMap<String, Object>();
        for (String key : allPrefs.keySet()) {
            if (!key.startsWith("flutter.")) continue;
            Object value = allPrefs.get(key);
            if (value instanceof String) {
                String stringValue = (String)value;
                if (stringValue.startsWith(LIST_IDENTIFIER)) {
                    value = this.decodeList(stringValue.substring(LIST_IDENTIFIER.length()));
                } else if (stringValue.startsWith(BIG_INTEGER_PREFIX)) {
                    String encoded = stringValue.substring(BIG_INTEGER_PREFIX.length());
                    value = new BigInteger(encoded, 36);
                } else if (stringValue.startsWith(DOUBLE_PREFIX)) {
                    String doubleStr = stringValue.substring(DOUBLE_PREFIX.length());
                    value = Double.valueOf(doubleStr);
                }
            } else if (value instanceof Set) {
                ArrayList<String> listValue = new ArrayList<String>((Set)value);
                boolean success = this.preferences.edit().remove(key).putString(key, LIST_IDENTIFIER + this.encodeList(listValue)).commit();
                if (!success) {
                    throw new IOException("Could not migrate set to list");
                }
                value = listValue;
            }
            filteredPrefs.put(key, value);
        }
        return filteredPrefs;
    }
}

