/*
 * Decompiled with CFR 0.152.
 */
package se.thinkcode;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import se.thinkcode.CucumberExtension;
import se.thinkcode.CucumberTask;
import se.thinkcode.PluginParser;

class CommandLineBuilder {
    CommandLineBuilder() {
    }

    String[] buildCommand(CucumberExtension extension, String classpath, CucumberTask commandLineOption) {
        String main = extension.main;
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        this.addSystemProperties(command);
        command.add("-cp");
        command.add(classpath);
        command.add(main);
        this.addHelp(command, extension, commandLineOption);
        this.addVersion(command, extension, commandLineOption);
        this.addI18N(command, extension, commandLineOption);
        this.addThreads(command, extension, commandLineOption);
        this.addGlue(command, extension, commandLineOption);
        this.addPlugin(command, extension, commandLineOption);
        this.addTags(command, extension, commandLineOption);
        this.addName(command, extension, commandLineOption);
        this.addDryRun(command, extension, commandLineOption);
        this.addMonochrome(command, extension, commandLineOption);
        this.addStrict(command, extension, commandLineOption);
        this.addSnippets(command, extension, commandLineOption);
        this.addWip(command, extension, commandLineOption);
        this.addFeaturePath(command, extension, commandLineOption);
        return command.toArray(new String[0]);
    }

    private void addSystemProperties(List<String> command) {
        Properties props = System.getProperties();
        for (Object key : props.keySet()) {
            String keyValue = (String)key;
            String value = props.getProperty(keyValue);
            String systemProperty = "-D" + keyValue + "=" + value;
            command.add(systemProperty);
        }
    }

    private void addHelp(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.help != null) {
            command.add("--help");
            return;
        }
        if (!extension.help.isEmpty()) {
            command.add("--help");
        }
    }

    private void addVersion(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.version != null) {
            command.add("--version");
            return;
        }
        if (!extension.version.isEmpty()) {
            command.add("--version");
        }
    }

    private void addI18N(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.i18n != null) {
            command.add("--i18n");
            command.add(commandLineOption.i18n);
            return;
        }
        if (!extension.i18n.isEmpty()) {
            command.add("--i18n");
            command.add(extension.i18n);
        }
    }

    private void addThreads(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.threads != null) {
            command.add("--threads");
            command.add(commandLineOption.threads);
            return;
        }
        if (!extension.threads.isEmpty()) {
            command.add("--threads");
            command.add(extension.threads);
        }
    }

    private void addGlue(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.glue != null) {
            command.add("--glue");
            command.add(commandLineOption.glue);
            return;
        }
        if (!extension.glue.isEmpty()) {
            command.add("--glue");
            command.add(extension.glue);
        }
    }

    private void addPlugin(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.plugin != null) {
            String[] plugins;
            for (String plugin : plugins = PluginParser.parse(commandLineOption.plugin)) {
                command.add("--plugin");
                command.add(plugin);
            }
            return;
        }
        if (extension.plugin.length > 0) {
            for (String plugin : extension.plugin) {
                command.add("--plugin");
                command.add(plugin);
            }
        }
    }

    private void addTags(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.tags != null) {
            command.add("--tags");
            command.add(commandLineOption.tags);
            return;
        }
        if (!extension.tags.isEmpty()) {
            command.add("--tags");
            command.add(extension.tags);
        }
    }

    private void addName(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.name != null) {
            command.add("--name");
            command.add(commandLineOption.name);
            return;
        }
        if (!extension.name.isEmpty()) {
            command.add("--name");
            command.add(extension.name);
        }
    }

    private void addDryRun(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.dryRun != null) {
            command.add("--dry-run");
            return;
        }
        if (!extension.dryRun.isEmpty()) {
            command.add("--dry-run");
        }
    }

    private void addMonochrome(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.monochrome != null) {
            command.add("--monochrome");
            command.add(commandLineOption.monochrome);
            return;
        }
        if (!extension.monochrome.isEmpty()) {
            command.add("--monochrome");
            command.add(extension.monochrome);
        }
    }

    private void addStrict(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.strict != null) {
            command.add("--strict");
            return;
        }
        if (!extension.strict.isEmpty()) {
            command.add("--strict");
        }
    }

    private void addSnippets(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.snippets != null) {
            command.add("--snippets");
            command.add(commandLineOption.snippets);
            return;
        }
        if (!extension.snippets.isEmpty()) {
            command.add("--snippets");
            command.add(extension.snippets);
        }
    }

    private void addWip(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.wip != null) {
            command.add("--wip");
            return;
        }
        if (!extension.wip.isEmpty()) {
            command.add("--wip");
        }
    }

    private void addFeaturePath(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.featurePath != null) {
            command.add(commandLineOption.featurePath);
            return;
        }
        if (!extension.featurePath.isEmpty()) {
            command.add(extension.featurePath);
        }
    }
}

