/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.plugin.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.bjurr.gitchangelog.api.GitChangelogApi;
import se.bjurr.gitchangelog.api.InclusivenessStrategy;
import se.bjurr.gitchangelog.plugin.gradle.CustomIssue;
import se.bjurr.gitchangelog.plugin.gradle.HelperParam;

public class GitChangelogTask
extends DefaultTask {
    private static final Logger log = LoggerFactory.getLogger((String)GitChangelogTask.class.getName());
    public Property<String> fromRepo = this.getProject().getObjects().property(String.class).convention((Object)this.getProject().getRootProject().getRootDir().getAbsolutePath());
    public Property<String> toRevision = this.getProject().getObjects().property(String.class);
    public Property<InclusivenessStrategy> toRevisionStrategy = this.getProject().getObjects().property(InclusivenessStrategy.class).convention((Object)InclusivenessStrategy.DEFAULT);
    public Property<String> fromRevision = this.getProject().getObjects().property(String.class);
    public Property<InclusivenessStrategy> fromRevisionStrategy = this.getProject().getObjects().property(InclusivenessStrategy.class).convention((Object)InclusivenessStrategy.DEFAULT);
    public Property<String> settingsFile = this.getProject().getObjects().property(String.class);
    public Property<String> templateBaseDir = this.getProject().getObjects().property(String.class);
    public Property<String> templateContent = this.getProject().getObjects().property(String.class);
    public Property<String> templateSuffix = this.getProject().getObjects().property(String.class);
    public Property<File> file = this.getProject().getObjects().property(File.class).convention((Object)this.getProject().file((Object)"CHANGELOG.md"));
    public Property<String> readableTagName = this.getProject().getObjects().property(String.class);
    public Property<String> dateFormat = this.getProject().getObjects().property(String.class);
    public Property<String> timeZone = this.getProject().getObjects().property(String.class);
    public Property<Boolean> removeIssueFromMessage = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    public Property<String> ignoreCommitsIfMessageMatches = this.getProject().getObjects().property(String.class);
    public Property<String> untaggedName = this.getProject().getObjects().property(String.class);
    public Property<String> noIssueName = this.getProject().getObjects().property(String.class);
    public Property<Boolean> ignoreCommitsWithoutIssue = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    public Property<String> ignoreTagsIfNameMatches = this.getProject().getObjects().property(String.class);
    public ListProperty<CustomIssue> customIssues = this.getProject().getObjects().listProperty(CustomIssue.class).convention(new ArrayList());
    public Property<Boolean> gitHubEnabled = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    public Property<String> gitHubApi = this.getProject().getObjects().property(String.class);
    public Property<String> gitHubToken = this.getProject().getObjects().property(String.class);
    public Property<String> gitHubIssuePattern = this.getProject().getObjects().property(String.class);
    public Property<Boolean> jiraEnabled = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    public Property<String> jiraUsername = this.getProject().getObjects().property(String.class);
    public Property<String> jiraPassword = this.getProject().getObjects().property(String.class);
    public Property<String> jiraIssuePattern = this.getProject().getObjects().property(String.class);
    public Property<String> jiraServer = this.getProject().getObjects().property(String.class);
    public Property<Boolean> gitLabEnabled = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    public Property<String> gitLabServer = this.getProject().getObjects().property(String.class);
    public Property<String> gitLabProjectName = this.getProject().getObjects().property(String.class);
    public Property<String> gitLabToken = this.getProject().getObjects().property(String.class);
    public Property<Date> ignoreCommitsOlderThan = this.getProject().getObjects().property(Date.class);
    public ListProperty<HelperParam> handlebarsHelpers = this.getProject().getObjects().listProperty(HelperParam.class).convention(new ArrayList());
    public Property<Boolean> useIntegrations = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    public Property<Boolean> prependToFile = this.getProject().getObjects().property(Boolean.class).convention((Object)false);

    public CustomIssue customIssue() {
        CustomIssue customIssue = new CustomIssue();
        this.customIssues.add((Object)customIssue);
        return customIssue;
    }

    @TaskAction
    public void gitChangelogPluginTasks() {
        try {
            GitChangelogApi builder = GitChangelogApi.gitChangelogApiBuilder().withUseIntegrations(((Boolean)this.useIntegrations.get()).booleanValue()).withJiraEnabled(((Boolean)this.jiraEnabled.get()).booleanValue()).withGitLabEnabled(((Boolean)this.gitLabEnabled.get()).booleanValue()).withGitHubEnabled(((Boolean)this.gitHubEnabled.get()).booleanValue());
            for (HelperParam helper : (List)this.handlebarsHelpers.get()) {
                builder.withHandlebarsHelper(helper.getName(), helper.getHelper());
            }
            if (this.settingsFile.isPresent()) {
                builder.withSettings(this.getProject().file(this.settingsFile).toURI().toURL());
            }
            builder.withFromRepo((String)this.fromRepo.get());
            if (this.fromRevision.isPresent()) {
                builder.withFromRevision((String)this.fromRevision.get(), (InclusivenessStrategy)this.fromRevisionStrategy.get());
            }
            if (this.toRevision.isPresent()) {
                builder.withToRevision((String)this.toRevision.get(), (InclusivenessStrategy)this.toRevisionStrategy.get());
            }
            if (this.templateBaseDir.isPresent()) {
                builder.withTemplateBaseDir((String)this.templateBaseDir.get());
            }
            if (this.templateContent.isPresent()) {
                builder.withTemplateContent((String)this.templateContent.get());
            }
            if (this.templateSuffix.isPresent()) {
                builder.withTemplateSuffix((String)this.templateSuffix.get());
            }
            if (this.ignoreTagsIfNameMatches.isPresent()) {
                builder.withIgnoreTagsIfNameMatches((String)this.ignoreTagsIfNameMatches.get());
            }
            if (this.readableTagName.isPresent()) {
                builder.withReadableTagName((String)this.readableTagName.get());
            }
            if (this.dateFormat.isPresent()) {
                builder.withDateFormat((String)this.dateFormat.get());
            }
            if (this.timeZone.isPresent()) {
                builder.withTimeZone((String)this.timeZone.get());
            }
            builder.withRemoveIssueFromMessageArgument(((Boolean)this.removeIssueFromMessage.get()).booleanValue());
            if (this.ignoreCommitsIfMessageMatches.isPresent()) {
                builder.withIgnoreCommitsWithMessage((String)this.ignoreCommitsIfMessageMatches.get());
            }
            if (this.ignoreCommitsOlderThan.isPresent()) {
                builder.withIgnoreCommitsOlderThan((Date)this.ignoreCommitsOlderThan.get());
            }
            if (this.untaggedName.isPresent()) {
                builder.withUntaggedName((String)this.untaggedName.get());
            }
            if (this.noIssueName.isPresent()) {
                builder.withNoIssueName((String)this.noIssueName.get());
            }
            builder.withIgnoreCommitsWithoutIssue(((Boolean)this.ignoreCommitsWithoutIssue.get()).booleanValue());
            for (CustomIssue customIssue : (List)this.customIssues.get()) {
                String name = customIssue.getName();
                String pattern = customIssue.getPattern();
                String link = customIssue.getLink();
                String title = customIssue.getTitle();
                builder.withCustomIssue(name, pattern, link, title);
            }
            if (this.gitHubApi.isPresent()) {
                builder.withGitHubApi((String)this.gitHubApi.get());
            }
            if (this.gitHubToken.isPresent()) {
                builder.withGitHubToken((String)this.gitHubToken.get());
            }
            if (this.gitHubIssuePattern.isPresent()) {
                builder.withGitHubIssuePattern((String)this.gitHubIssuePattern.get());
            }
            if (this.gitLabProjectName.isPresent()) {
                builder.withGitLabProjectName((String)this.gitLabProjectName.get());
            }
            if (this.gitLabServer.isPresent()) {
                builder.withGitLabServer((String)this.gitLabServer.get());
            }
            if (this.gitLabToken.isPresent()) {
                builder.withGitLabToken((String)this.gitLabToken.get());
            }
            if (this.jiraUsername.isPresent()) {
                builder.withJiraUsername((String)this.jiraUsername.get());
            }
            if (this.jiraPassword.isPresent()) {
                builder.withJiraPassword((String)this.jiraPassword.get());
            }
            if (this.jiraIssuePattern.isPresent()) {
                builder.withJiraIssuePattern((String)this.jiraIssuePattern.get());
            }
            if (this.jiraServer.isPresent()) {
                builder.withJiraServer((String)this.jiraServer.get());
            }
            if (this.file.isPresent()) {
                if (((Boolean)this.prependToFile.get()).booleanValue()) {
                    builder.prependToFile((File)this.file.get());
                } else {
                    builder.toFile((File)this.file.get());
                }
                log.info("#");
                log.info("# Wrote: " + String.valueOf(this.file) + " to: " + String.valueOf(((File)this.file.get()).getCanonicalFile().toPath()));
                log.info("#");
            }
        }
        catch (Exception e) {
            log.error("GitChangelog", (Throwable)e);
        }
    }
}

