/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.showdependencies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.gradle.plugins.library.dependencies.ArtifactVersionResolver;

public class PrintNewDependenciesAction
implements Action<Project> {
    private static final Logger log = LoggerFactory.getLogger(PrintNewDependenciesAction.class);
    private final Map<Dependency, Boolean> checked = new HashMap<Dependency, Boolean>();
    @Nonnull
    private final Set<String> includeGroupIdPrefixes;
    @Nonnull
    private final ArtifactVersionResolver artifactVersionResolver;

    PrintNewDependenciesAction(@Nonnull ArtifactVersionResolver artifactVersionResolver) {
        this(Collections.emptySet(), artifactVersionResolver);
    }

    PrintNewDependenciesAction(@Nonnull Set<String> includeGroupIdPrefixes, @Nonnull ArtifactVersionResolver artifactVersionResolver) {
        this.includeGroupIdPrefixes = Objects.requireNonNull(includeGroupIdPrefixes, "includeGroupIdPrefixes");
        this.artifactVersionResolver = Objects.requireNonNull(artifactVersionResolver, "artifactVersionResolver");
    }

    public void execute(Project project) {
        Collection configurations = project.getConfigurations().getAsMap().values();
        Collection buildscriptConfigurations = project.getBuildscript().getConfigurations().getAsMap().values();
        List allConfigurations = Stream.of(configurations, buildscriptConfigurations).flatMap(Collection::stream).collect(Collectors.toList());
        for (Configuration configuration : allConfigurations) {
            try {
                Set resolvedArtifacts = configuration.getResolvedConfiguration().getResolvedArtifacts();
                List moduleVersionIdentifiers = resolvedArtifacts.stream().map(ra -> ra.getModuleVersion().getId()).collect(Collectors.toList());
                Map<String, String> resolvedVersionMap = moduleVersionIdentifiers.stream().collect(Collectors.toMap(mvId -> mvId.getGroup() + ":" + mvId.getName(), ModuleVersionIdentifier::getVersion));
                configuration.getAllDependencies().forEach(dependency -> {
                    if (this.checked.containsKey(dependency)) {
                        return;
                    }
                    this.checked.put((Dependency)dependency, true);
                    if (this.doNeedPrint((Dependency)dependency)) {
                        String realVersion = (String)resolvedVersionMap.get(dependency.getGroup() + ":" + dependency.getName());
                        try {
                            this.printLatestDependencyVersion((Dependency)dependency, realVersion);
                        }
                        catch (Exception e) {
                            log.warn("Can't get latest dependency version: {}:{} {}", new Object[]{dependency.getGroup(), dependency.getName(), realVersion});
                        }
                    }
                });
            }
            catch (IllegalStateException e) {
                log.info(String.format("The trouble with resolve configuration: configuration=%s", configuration.getName()), (Throwable)e);
            }
        }
    }

    private void printLatestDependencyVersion(Dependency dependency, String realVersion) {
        Optional.of(dependency).filter(dep -> dep.getGroup() != null).flatMap(dep -> this.artifactVersionResolver.getArtifactLatestVersion(dependency.getGroup(), dependency.getName())).filter(newVersion -> !Objects.equals(realVersion, newVersion)).ifPresent(newVersion -> this.printNewVersion(dependency, realVersion, (String)newVersion));
    }

    private void printNewVersion(Dependency dependency, String realVersion, String newVersion) {
        log.warn("New available version: {}:{} {} -> {}", new Object[]{dependency.getGroup(), dependency.getName(), realVersion, newVersion});
    }

    private boolean doNeedPrint(@Nonnull Dependency dependency) {
        Objects.requireNonNull(dependency, "dependency");
        if (this.includeGroupIdPrefixes.isEmpty()) {
            return true;
        }
        return this.includeGroupIdPrefixes.stream().anyMatch(prefix -> dependency.getGroup() != null && dependency.getGroup().startsWith((String)prefix));
    }
}

