/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.forbiddenartifacts;

import groovy.lang.Closure;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.util.ConfigureUtil;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactName;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactWithVersionRange;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ForbiddenArtifactInfo;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;

public class ForbiddenDependenciesExtension {
    public Set<ForbiddenArtifactInfo> forbiddenArtifacts = new HashSet<ForbiddenArtifactInfo>();

    public void eq(Closure closure) {
        this.eq(this.createForbiddenArtifactInfo(closure));
    }

    public void eq(ForbiddenArtifactParameter forbiddenArtifactParameter) {
        ArtifactName forbiddenArtifact = ArtifactName.parse(forbiddenArtifactParameter.forbidden);
        LibraryName libraryName = forbiddenArtifact.getLibraryName();
        this.forbiddenArtifacts.add(this.createForbiddenArtifact(forbiddenArtifactParameter, new ArtifactWithVersionRange(libraryName, forbiddenArtifact.getVersion())));
    }

    public void range(Closure closure) {
        this.range(this.createForbiddenArtifactInfo(closure));
    }

    public void range(ForbiddenArtifactParameter forbiddenArtifactParameter) {
        LibraryName forbiddenLibraryName = LibraryName.parse(forbiddenArtifactParameter.forbidden);
        this.forbiddenArtifacts.add(this.createForbiddenArtifact(forbiddenArtifactParameter, new ArtifactWithVersionRange(forbiddenLibraryName, forbiddenArtifactParameter.startVersion, forbiddenArtifactParameter.endVersion)));
    }

    public void before(Closure closure) {
        this.before(this.createForbiddenArtifactInfo(closure));
    }

    public void before(ForbiddenArtifactParameter forbiddenArtifactParameter) {
        ArtifactName forbiddenArtifactName = ArtifactName.parse(forbiddenArtifactParameter.forbidden);
        this.forbiddenArtifacts.add(this.createForbiddenArtifact(forbiddenArtifactParameter, new ArtifactWithVersionRange(forbiddenArtifactName.getLibraryName(), null, forbiddenArtifactName.getVersion())));
    }

    public void after(Closure closure) {
        this.after(this.createForbiddenArtifactInfo(closure));
    }

    public void after(ForbiddenArtifactParameter forbiddenArtifactParameter) {
        ArtifactName forbiddenArtifactName = ArtifactName.parse(forbiddenArtifactParameter.forbidden);
        this.forbiddenArtifacts.add(this.createForbiddenArtifact(forbiddenArtifactParameter, new ArtifactWithVersionRange(forbiddenArtifactName.getLibraryName(), forbiddenArtifactName.getVersion(), null)));
    }

    private ForbiddenArtifactInfo createForbiddenArtifact(ForbiddenArtifactParameter forbiddenArtifactParameter, ArtifactWithVersionRange artifactWithVersionRange) {
        return ForbiddenArtifactInfo.builder().withForbiddenArtifact(artifactWithVersionRange).withRecommendedArtifact(new ArtifactName(artifactWithVersionRange.getLibraryName(), forbiddenArtifactParameter.recommended)).withComment(forbiddenArtifactParameter.comment).build();
    }

    private ForbiddenArtifactParameter createForbiddenArtifactInfo(Closure closure) {
        Action action = ConfigureUtil.configureUsing((Closure)closure);
        ForbiddenArtifactParameter forbiddenArtifactParameter = new ForbiddenArtifactParameter();
        action.execute((Object)forbiddenArtifactParameter);
        return forbiddenArtifactParameter;
    }

    public static class ForbiddenArtifactParameter {
        private String forbidden;
        private String recommended;
        private String comment;
        private String startVersion;
        private String endVersion;

        public ForbiddenArtifactParameter recommended(String recommended) {
            this.recommended = recommended;
            return this;
        }

        public ForbiddenArtifactParameter forbidden(String forbidden) {
            this.forbidden = forbidden;
            return this;
        }

        public ForbiddenArtifactParameter comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ForbiddenArtifactParameter startVersion(String startVersion) {
            this.startVersion = startVersion;
            return this;
        }

        public ForbiddenArtifactParameter endVersion(String endVersion) {
            this.endVersion = endVersion;
            return this;
        }
    }
}

