/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.dsl;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LibraryName {
    private static final Pattern LIBRARY_NAME_PATTERN = Pattern.compile("(?<group>.+):(?<name>.+)");
    private final String group;
    private final String name;

    public static LibraryName parse(String libraryName) {
        Matcher matcher = LIBRARY_NAME_PATTERN.matcher(libraryName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Passed library name has incorrect format: expected '<group>:<name>'");
        }
        return new LibraryName(matcher.group("group"), matcher.group("name"));
    }

    public LibraryName(String group, String name) {
        this.group = group;
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LibraryName)) {
            return false;
        }
        LibraryName other = (LibraryName)object;
        return Objects.equals(this.group, other.group) && Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return 7 * this.group.hashCode() + this.name.hashCode();
    }

    public String toString() {
        return this.group + ":" + this.name;
    }
}

