/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.dsl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;

public class ArtifactWithVersionRange {
    private final LibraryName libraryName;
    private final String startVersion;
    private final String endVersion;

    public ArtifactWithVersionRange(@Nonnull LibraryName libraryName, @Nullable String startVersion, @Nullable String endVersion) {
        if (startVersion == null && endVersion == null) {
            throw new RuntimeException(String.format("StartVersion and endVersion are null for library: %s", libraryName));
        }
        this.libraryName = libraryName;
        this.startVersion = startVersion;
        this.endVersion = endVersion;
    }

    public ArtifactWithVersionRange(LibraryName libraryName, @Nonnull String version) {
        this.libraryName = libraryName;
        this.startVersion = version;
        this.endVersion = version;
    }

    public boolean isVersionIncludedInRange(String version) {
        if (this.startVersion == null) {
            return this.compareVersions(this.endVersion, version) >= 0;
        }
        if (this.endVersion == null) {
            return this.compareVersions(this.startVersion, version) <= 0;
        }
        return this.compareVersions(this.startVersion, version) <= 0 && this.compareVersions(this.endVersion, version) >= 0;
    }

    public LibraryName getLibraryName() {
        return this.libraryName;
    }

    private int compareVersions(String version1, String version2) {
        String[] versionAsArray1 = version1.split("\\.");
        String[] versionAsArray2 = version2.split("\\.");
        for (int i = 0; i < Math.min(versionAsArray1.length, versionAsArray2.length); ++i) {
            Integer num2;
            Integer num1 = Integer.valueOf(versionAsArray1[i]);
            if (num1.equals(num2 = Integer.valueOf(versionAsArray2[i]))) continue;
            return num1.compareTo(num2);
        }
        return 0;
    }
}

