/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.dsl;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactName;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;

public class ArtifactNameSet
implements Iterable<ArtifactName> {
    private final Map<LibraryName, Set<String>> libraryVersions;

    public static ArtifactNameSet fromLibraryVersions(Map<LibraryName, Set<String>> libraryVersions) {
        return new ArtifactNameSet(libraryVersions);
    }

    private ArtifactNameSet(Map<LibraryName, Set<String>> libraryVersions) {
        this.libraryVersions = libraryVersions;
    }

    public Set<String> getVersions(LibraryName libraryName) {
        return Optional.ofNullable(this.libraryVersions.get(libraryName)).orElseGet(Collections::emptySet);
    }

    public boolean contains(@Nonnull LibraryName libraryName) {
        Objects.requireNonNull(libraryName, "libraryName");
        return this.libraryVersions != null && libraryName.getGroup() != null && libraryName.getName() != null && this.libraryVersions.containsKey(libraryName);
    }

    @Override
    public Iterator<ArtifactName> iterator() {
        return this.libraryVersions.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(version -> new ArtifactName((LibraryName)entry.getKey(), (String)version))).iterator();
    }
}

