/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.dsl;

import java.util.Objects;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;

public final class ArtifactName {
    private final LibraryName libraryName;
    private final String version;

    public static ArtifactName parse(String name) {
        int libraryNameLength = name.lastIndexOf(58);
        if (libraryNameLength == -1) {
            throw new IllegalArgumentException("Passed artifact name has incorrect format");
        }
        String libraryName = name.substring(0, libraryNameLength);
        String version = name.substring(libraryNameLength + 1);
        return new ArtifactName(LibraryName.parse(libraryName), version);
    }

    public static ArtifactName changeVersion(ArtifactName artifactName, String version) {
        return new ArtifactName(artifactName.getLibraryName(), version);
    }

    public ArtifactName(String group, String name, String version) {
        this(new LibraryName(group, name), version);
    }

    public ArtifactName(LibraryName libraryName, String version) {
        this.libraryName = libraryName;
        this.version = version;
    }

    public LibraryName getLibraryName() {
        return this.libraryName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArtifactName)) {
            return false;
        }
        ArtifactName other = (ArtifactName)object;
        return Objects.equals(this.libraryName, other.libraryName) && Objects.equals(this.version, other.version);
    }

    public int hashCode() {
        return 7 * this.libraryName.hashCode() + this.version.hashCode();
    }
}

