/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.checkversion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.DependencyResolveDetails;
import ru.yoomoney.gradle.plugins.library.dependencies.ArtifactVersionResolver;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;

class FindAllVersionConflictAction
implements Action<DependencyResolveDetails> {
    private final Set<LibraryName> excludedLibraries;
    private final Set<String> includePrefixLibraries;
    private final Map<LibraryName, String> majorModuleVersions = new HashMap<LibraryName, String>();
    private final Map<LibraryName, Set<String>> conflictModules;
    private final ArtifactVersionResolver artifactVersionResolver;

    FindAllVersionConflictAction(Set<LibraryName> excludedLibraries, Set<String> includePrefixLibraries, Map<LibraryName, Set<String>> conflictModules, ArtifactVersionResolver artifactVersionResolver) {
        this.excludedLibraries = excludedLibraries;
        this.conflictModules = conflictModules;
        this.includePrefixLibraries = includePrefixLibraries;
        this.artifactVersionResolver = artifactVersionResolver;
    }

    public void execute(DependencyResolveDetails dependency) {
        String requestedVersion = dependency.getRequested().getVersion();
        if (requestedVersion == null) {
            return;
        }
        String groupDependency = dependency.getRequested().getGroup();
        String nameDependency = dependency.getRequested().getName();
        if ("+".equals(requestedVersion) || "latest.release".equals(requestedVersion)) {
            requestedVersion = this.artifactVersionResolver.getArtifactLatestVersion(groupDependency, nameDependency).orElseThrow(() -> new GradleException(String.format("Not found version: dependency=%s:%s", groupDependency, nameDependency)));
        }
        LibraryName libraryName = new LibraryName(groupDependency, nameDependency);
        String savedVersion = this.majorModuleVersions.get(libraryName);
        String majorRequestedVersion = FindAllVersionConflictAction.getMajorVer(requestedVersion);
        if (savedVersion == null) {
            this.majorModuleVersions.put(libraryName, majorRequestedVersion);
        } else if (this.isNeedCheck(libraryName) && !Objects.equals(majorRequestedVersion, savedVersion)) {
            Set versionSet = this.conflictModules.getOrDefault(libraryName, new HashSet());
            versionSet.add(requestedVersion);
            versionSet.add(savedVersion);
            this.conflictModules.put(libraryName, versionSet);
        }
    }

    private static String getMajorVer(String ver) {
        return ver.split("\\.")[0];
    }

    private boolean isNeedCheck(LibraryName libraryName) {
        boolean isLibraryInExcluded = this.excludedLibraries.contains(libraryName);
        return !isLibraryInExcluded && (this.includePrefixLibraries.isEmpty() || this.includePrefixLibraries.stream().anyMatch(prefix -> libraryName.getGroup().startsWith((String)prefix)));
    }
}

