/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.DependencyPathBuilder;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.Artifact;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactDependent;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactName;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.DependencyPath;

public class ArtifactDependentPathsFinder<ArtifactT extends Artifact<ArtifactT>> {
    private final ArtifactDependent<ArtifactT> root;
    private final Predicate<? super ArtifactName> isRequestedArtifact;
    private Set<ArtifactName> visitedArtifacts;
    private List<DependencyPath<ArtifactT>> foundPaths;

    public ArtifactDependentPathsFinder(ArtifactDependent<ArtifactT> root, Predicate<? super ArtifactName> isRequestedArtifact) {
        this.root = root;
        this.isRequestedArtifact = isRequestedArtifact;
    }

    public List<DependencyPath<ArtifactT>> findPaths() {
        this.initialize();
        this.traverse(this.root, DependencyPathBuilder.create());
        return this.foundPaths;
    }

    private void initialize() {
        this.visitedArtifacts = new HashSet<ArtifactName>();
        this.foundPaths = new ArrayList<DependencyPath<ArtifactT>>();
    }

    private void traverse(ArtifactDependent<ArtifactT> root, DependencyPathBuilder<ArtifactT> dependencyPathBuilder) {
        for (Artifact artifact : root.getDependencies()) {
            this.visitDependency(artifact, dependencyPathBuilder);
        }
    }

    private void visitDependency(ArtifactT dependency, DependencyPathBuilder<ArtifactT> dependencyPathBuilder) {
        dependencyPathBuilder = dependencyPathBuilder.copy();
        dependencyPathBuilder.add(dependency);
        if (this.isRequested(dependency)) {
            this.foundPaths.add(dependencyPathBuilder.build());
            return;
        }
        if (this.visitedArtifacts.contains(dependency.getName())) {
            return;
        }
        this.visitedArtifacts.add(dependency.getName());
        for (Artifact childDependency : dependency.getDependencies()) {
            this.visitDependency(childDependency, dependencyPathBuilder);
        }
    }

    private boolean isRequested(ArtifactT foundArtifact) {
        ArtifactName foundArtifactName = foundArtifact.getName();
        return this.isRequestedArtifact.test(foundArtifactName);
    }
}

