/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.FixedDependencies;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.ConfigurationConflictsAnalyzer;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.ConflictedLibraryInfo;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;

public class CheckDependenciesTask
extends ConventionTask {
    private final Logger log = LoggerFactory.getLogger(CheckDependenciesTask.class);
    private FixedDependencies fixedDependencies;
    @Input
    private List<String> includedConfigurations;

    @TaskAction
    public void check() {
        this.fixedDependencies = FixedDependencies.from(this.getProject());
        for (Configuration configuration : this.getCheckedConfigurations()) {
            List conflictedLibraries = this.calculateConflictedVersionsLibrariesFor(configuration).stream().filter(conflict -> !conflict.getVersion().isEmpty()).collect(Collectors.toList());
            if (!conflictedLibraries.isEmpty()) {
                this.log.warn("There are conflicts: {}", conflictedLibraries);
            }
            configuration.getAllDependencies().stream().filter(dep -> this.fixedDependencies.forConfiguration(configuration).contains(new LibraryName(dep.getGroup(), dep.getName()))).filter(dep -> dep.getVersion() != null && !dep.getVersion().isEmpty()).forEach(dep -> this.log.warn("Fixed dependency are overridden in the local build.gradle. Please, remove the version for these dependencies: {}:{}:{}", new Object[]{dep.getGroup(), dep.getName(), dep.getVersion()}));
        }
    }

    private Iterable<Configuration> getCheckedConfigurations() {
        List<String> included = this.getIncludedConfigurations();
        return this.getProject().getConfigurations().matching(configuration -> included != null && included.contains(configuration.getName()));
    }

    private List<ConflictedLibraryInfo> calculateConflictedVersionsLibrariesFor(@Nonnull Configuration configuration) {
        return ConfigurationConflictsAnalyzer.create(this.fixedDependencies, configuration).findConflictedLibraries();
    }

    @Nullable
    List<String> getIncludedConfigurations() {
        return this.includedConfigurations;
    }

    void setIncludedConfigurations(List<String> includedConfigurations) {
        this.includedConfigurations = new ArrayList<String>(includedConfigurations);
    }
}

