/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql.config;

import de.flapdoodle.embed.process.builder.IProperty;
import de.flapdoodle.embed.process.builder.TypedProperty;
import de.flapdoodle.embed.process.config.store.DownloadConfigBuilder;
import de.flapdoodle.embed.process.config.store.DownloadPath;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.IDownloadPath;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.config.store.IProxyFactory;
import de.flapdoodle.embed.process.config.store.ITimeoutConfig;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.extract.UUIDTempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.directories.UserHome;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import de.flapdoodle.embed.process.io.progress.StandardConsoleProgressListener;
import ru.yandex.qatools.embed.postgresql.Command;
import ru.yandex.qatools.embed.postgresql.PackagePaths;
import ru.yandex.qatools.embed.postgresql.config.MutableDownloadConfig;
import ru.yandex.qatools.embed.postgresql.ext.SubdirTempDir;

public class PostgresDownloadConfigBuilder
extends DownloadConfigBuilder {
    private static final TypedProperty<DownloadConfigBuilder.UserAgent> USER_AGENT = TypedProperty.with((String)"UserAgent", DownloadConfigBuilder.UserAgent.class);
    private static final TypedProperty<IProgressListener> PROGRESS_LISTENER = TypedProperty.with((String)"ProgressListener", IProgressListener.class);
    private static final TypedProperty<ITempNaming> FILE_NAMING = TypedProperty.with((String)"FileNaming", ITempNaming.class);
    private static final TypedProperty<IDirectory> ARTIFACT_STORE_PATH = TypedProperty.with((String)"ArtifactStorePath", IDirectory.class);
    private static final TypedProperty<IPackageResolver> PACKAGE_RESOLVER = TypedProperty.with((String)"PackageResolver", IPackageResolver.class);
    private static final TypedProperty<DownloadConfigBuilder.DownloadPrefix> DOWNLOAD_PREFIX = TypedProperty.with((String)"DownloadPrefix", DownloadConfigBuilder.DownloadPrefix.class);
    private static final TypedProperty<IDownloadPath> DOWNLOAD_PATH = TypedProperty.with((String)"DownloadPath", IDownloadPath.class);
    private static final TypedProperty<ITimeoutConfig> TIMEOUT_CONFIG = TypedProperty.with((String)"TimeoutConfig", ITimeoutConfig.class);
    private static final TypedProperty<IProxyFactory> PROXY_FACTORY = TypedProperty.with((String)"ProxyFactory", IProxyFactory.class);

    public PostgresDownloadConfigBuilder defaultsForCommand(Command command) {
        this.fileNaming().setDefault((Object)new UUIDTempNaming());
        this.downloadPath().setDefault((Object)new DownloadPath("http://get.enterprisedb.com/postgresql/"));
        this.packageResolver().setDefault((Object)new PackagePaths(command, SubdirTempDir.defaultInstance()));
        this.artifactStorePath().setDefault((Object)new UserHome(".embedpostgresql"));
        this.downloadPrefix().setDefault((Object)new DownloadConfigBuilder.DownloadPrefix("postgresql-download"));
        this.userAgent().setDefault((Object)new DownloadConfigBuilder.UserAgent("Mozilla/5.0 (compatible; Embedded postgres; +https://github.com/yandex-qatools)"));
        this.progressListener().setDefault((Object)new StandardConsoleProgressListener(){

            public void info(String label, String message) {
                if (label.startsWith("Extract")) {
                    System.out.print(".");
                } else {
                    super.info(label, message);
                }
            }
        });
        return this;
    }

    public IDownloadConfig build() {
        IDownloadPath downloadPath = (IDownloadPath)this.get(DOWNLOAD_PATH);
        String downloadPrefix = (String)((DownloadConfigBuilder.DownloadPrefix)this.get(DOWNLOAD_PREFIX)).value();
        IPackageResolver packageResolver = (IPackageResolver)this.get(PACKAGE_RESOLVER);
        IDirectory artifactStorePath = (IDirectory)this.get(ARTIFACT_STORE_PATH);
        ITempNaming fileNaming = (ITempNaming)this.get(FILE_NAMING);
        IProgressListener progressListener = (IProgressListener)this.get(PROGRESS_LISTENER);
        String userAgent = (String)((DownloadConfigBuilder.UserAgent)this.get(USER_AGENT)).value();
        ITimeoutConfig timeoutConfig = (ITimeoutConfig)this.get(TIMEOUT_CONFIG);
        IProxyFactory proxyFactory = (IProxyFactory)this.get(PROXY_FACTORY);
        return new MutableDownloadConfig(downloadPath, downloadPrefix, packageResolver, artifactStorePath, fileNaming, progressListener, userAgent, timeoutConfig, proxyFactory);
    }

    public DownloadConfigBuilder downloadPath(String path) {
        this.set(DOWNLOAD_PATH, new DownloadPath(path));
        return this;
    }

    protected IProperty<IDownloadPath> downloadPath() {
        return this.property(DOWNLOAD_PATH);
    }

    public DownloadConfigBuilder downloadPrefix(String prefix) {
        this.set(DOWNLOAD_PREFIX, new DownloadConfigBuilder.DownloadPrefix(prefix));
        return this;
    }

    protected IProperty<DownloadConfigBuilder.DownloadPrefix> downloadPrefix() {
        return this.property(DOWNLOAD_PREFIX);
    }

    public DownloadConfigBuilder packageResolver(IPackageResolver packageResolver) {
        this.set(PACKAGE_RESOLVER, packageResolver);
        return this;
    }

    protected IProperty<IPackageResolver> packageResolver() {
        return this.property(PACKAGE_RESOLVER);
    }

    public DownloadConfigBuilder artifactStorePath(IDirectory artifactStorePath) {
        this.set(ARTIFACT_STORE_PATH, artifactStorePath);
        return this;
    }

    protected IProperty<IDirectory> artifactStorePath() {
        return this.property(ARTIFACT_STORE_PATH);
    }

    public DownloadConfigBuilder fileNaming(ITempNaming fileNaming) {
        this.set(FILE_NAMING, fileNaming);
        return this;
    }

    protected IProperty<ITempNaming> fileNaming() {
        return this.property(FILE_NAMING);
    }

    public DownloadConfigBuilder progressListener(IProgressListener progressListener) {
        this.set(PROGRESS_LISTENER, progressListener);
        return this;
    }

    protected IProperty<IProgressListener> progressListener() {
        return this.property(PROGRESS_LISTENER);
    }

    public DownloadConfigBuilder userAgent(String userAgent) {
        this.set(USER_AGENT, new DownloadConfigBuilder.UserAgent(userAgent));
        return this;
    }

    protected IProperty<DownloadConfigBuilder.UserAgent> userAgent() {
        return this.property(USER_AGENT);
    }

    public DownloadConfigBuilder timeoutConfig(ITimeoutConfig timeoutConfig) {
        this.set(TIMEOUT_CONFIG, timeoutConfig);
        return this;
    }

    protected IProperty<ITimeoutConfig> timeoutConfig() {
        return this.property(TIMEOUT_CONFIG);
    }

    public DownloadConfigBuilder proxyFactory(IProxyFactory proxyFactory) {
        this.set(PROXY_FACTORY, proxyFactory);
        return this;
    }

    protected IProperty<IProxyFactory> proxyFactory() {
        return this.property(PROXY_FACTORY);
    }
}

