/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.utils;

import java.util.Map;
import java.util.Set;
import ru.yandex.qatools.allure.Allure;
import ru.yandex.qatools.allure.events.TestSuiteFinishedEvent;
import ru.yandex.qatools.allure.model.Failure;
import ru.yandex.qatools.allure.model.Status;
import ru.yandex.qatools.allure.model.TestCaseResult;
import ru.yandex.qatools.allure.model.TestSuiteResult;

public class AllureShutdownHook
implements Runnable {
    private final Set<Map.Entry<String, TestSuiteResult>> testSuites;

    public AllureShutdownHook(Set<Map.Entry<String, TestSuiteResult>> testSuites) {
        this.testSuites = testSuites;
    }

    @Override
    public void run() {
        for (Map.Entry<String, TestSuiteResult> entry : this.testSuites) {
            for (TestCaseResult testCase : entry.getValue().getTestCases()) {
                this.markTestcaseAsInterruptedIfNotFinishedYet(testCase);
            }
            entry.getValue().getTestCases().add(this.createFakeTestcaseWithWarning(entry.getValue()));
            Allure.LIFECYCLE.fire(new TestSuiteFinishedEvent(entry.getKey()));
        }
    }

    public TestCaseResult createFakeTestcaseWithWarning(TestSuiteResult testSuite) {
        return new TestCaseResult().withName(testSuite.getName()).withTitle(testSuite.getName()).withStart(testSuite.getStart()).withStop(System.currentTimeMillis()).withFailure(new Failure().withMessage("Test suite was interrupted, some test cases may be lost")).withStatus(Status.BROKEN);
    }

    public void markTestcaseAsInterruptedIfNotFinishedYet(TestCaseResult testCase) {
        if (testCase.getStop() == 0L) {
            testCase.setStop(System.currentTimeMillis());
            testCase.setStatus(Status.BROKEN);
            testCase.setFailure(new Failure().withMessage("Test was interrupted"));
        }
    }
}

