/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util.walk;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeUtils;
import ru.vyarus.java.generics.resolver.util.map.IgnoreGenericsMap;
import ru.vyarus.java.generics.resolver.util.walk.TypesVisitor;

public class ComparatorTypesVisitor
implements TypesVisitor {
    private static final IgnoreGenericsMap IGNORE = IgnoreGenericsMap.getInstance();
    private boolean compatible = true;
    private boolean moreSpecific = true;

    @Override
    public boolean next(Type one, Type two) {
        if (two != Object.class) {
            Object[] twoBounds;
            Object[] oneBounds = GenericsUtils.resolveUpperBounds(one, IGNORE);
            boolean boundsEqual = Arrays.equals(oneBounds, twoBounds = GenericsUtils.resolveUpperBounds(two, IGNORE));
            if (!boundsEqual) {
                this.moreSpecific = oneBounds[0] != Object.class && TypeUtils.isAssignableBounds((Class[])oneBounds, (Class[])twoBounds);
            }
            this.moreSpecific = this.moreSpecific && this.compareLowerBounds(one, two);
            return this.moreSpecific && boundsEqual;
        }
        return true;
    }

    @Override
    public void incompatibleHierarchy(Type one, Type two) {
        this.compatible = false;
    }

    public boolean isMoreSpecific() {
        return this.moreSpecific;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    private boolean compareLowerBounds(Type one, Type two) {
        boolean res = this.notLowerBounded(two) ? true : (this.notLowerBounded(one) ? one != Object.class : TypeUtils.isMoreSpecific(((WildcardType)two).getLowerBounds()[0], ((WildcardType)one).getLowerBounds()[0]));
        return res;
    }

    private boolean notLowerBounded(Type type) {
        return !(type instanceof WildcardType) || ((WildcardType)type).getLowerBounds().length == 0;
    }
}

