/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.vyarus.java.generics.resolver.context.container.WildcardTypeImpl;
import ru.vyarus.java.generics.resolver.error.GenericsResolutionException;
import ru.vyarus.java.generics.resolver.error.IncompatibleTypesException;
import ru.vyarus.java.generics.resolver.error.UnknownGenericException;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;
import ru.vyarus.java.generics.resolver.util.TypeUtils;
import ru.vyarus.java.generics.resolver.util.map.EmptyGenericsMap;
import ru.vyarus.java.generics.resolver.util.map.IgnoreGenericsMap;

public final class GenericsResolutionUtils {
    private static final String GROOVY_OBJECT = "GroovyObject";

    private GenericsResolutionUtils() {
    }

    public static Map<Class<?>, LinkedHashMap<String, Type>> resolve(Class<?> type, Class<?> ... ignoreClasses) {
        return GenericsResolutionUtils.resolve(type, GenericsResolutionUtils.resolveRawGenerics(type), Collections.<Class<?>, LinkedHashMap<String, Type>>emptyMap(), Arrays.asList(ignoreClasses));
    }

    public static Map<Class<?>, LinkedHashMap<String, Type>> resolve(Class<?> type, LinkedHashMap<String, Type> rootGenerics, Map<Class<?>, LinkedHashMap<String, Type>> knownGenerics, List<Class<?>> ignoreClasses) {
        HashMap generics = new HashMap();
        generics.put(type, rootGenerics);
        try {
            GenericsResolutionUtils.analyzeType(generics, type, knownGenerics, ignoreClasses);
        }
        catch (Exception ex) {
            throw new GenericsResolutionException(type, rootGenerics, knownGenerics, ex);
        }
        return generics;
    }

    public static LinkedHashMap<String, Type> resolveGenerics(Type type, Map<String, Type> generics) {
        LinkedHashMap<String, Type> res;
        if (type instanceof ParameterizedType) {
            ParameterizedType actualType = (ParameterizedType)GenericsUtils.resolveTypeVariables(type, generics);
            Type[] genericTypes = actualType.getActualTypeArguments();
            Class target = (Class)actualType.getRawType();
            TypeVariable<Class<T>>[] genericNames = target.getTypeParameters();
            res = GenericsResolutionUtils.fillOuterGenerics(type, new LinkedHashMap<String, Type>(), null);
            int cnt = genericNames.length;
            for (int i = 0; i < cnt; ++i) {
                res.put(genericNames[i].getName(), genericTypes[i]);
            }
        } else {
            res = GenericsResolutionUtils.resolveRawGenerics(GenericsUtils.resolveClass(type, generics));
        }
        return res;
    }

    public static LinkedHashMap<String, Type> resolveRawGenerics(Class<?> type) {
        return GenericsResolutionUtils.fillOuterGenerics(type, GenericsResolutionUtils.resolveDirectRawGenerics(type), null);
    }

    public static LinkedHashMap<String, Type> resolveDirectRawGenerics(Class<?> type) {
        return GenericsResolutionUtils.resolveRawGenericsChain(type.getTypeParameters(), null);
    }

    public static LinkedHashMap<String, Type> resolveDirectRawGenerics(Method method, Map<String, Type> generics) {
        return GenericsResolutionUtils.resolveRawGenericsChain(method.getTypeParameters(), generics);
    }

    public static LinkedHashMap<String, Type> resolveDirectRawGenerics(Constructor constructor, Map<String, Type> generics) {
        return GenericsResolutionUtils.resolveRawGenericsChain(constructor.getTypeParameters(), generics);
    }

    public static Type resolveRawGeneric(TypeVariable variable, LinkedHashMap<String, Type> generics) {
        Object res;
        if (variable.getBounds().length > 1) {
            ArrayList<Type> types = new ArrayList<Type>();
            for (Type bound : variable.getBounds()) {
                Type actual = GenericsUtils.resolveTypeVariables(bound, generics);
                if (actual instanceof WildcardType && ((WildcardType)actual).getUpperBounds().length > 0) {
                    types.addAll(Arrays.asList(GenericsUtils.resolveTypeVariables(((WildcardType)actual).getUpperBounds(), generics)));
                    continue;
                }
                types.add(actual);
            }
            types.remove(Object.class);
            res = types.size() > 1 ? WildcardTypeImpl.upper(types.toArray(new Type[0])) : (types.isEmpty() ? Object.class : (Type)types.get(0));
        } else {
            res = GenericsUtils.resolveTypeVariables(variable.getBounds()[0], generics);
        }
        return res;
    }

    public static LinkedHashMap<String, Type> fillOuterGenerics(Type type, LinkedHashMap<String, Type> generics, Map<Class<?>, LinkedHashMap<String, Type>> knownGenerics) {
        LinkedHashMap<String, Type> res;
        Type outer = TypeUtils.getOuter(type);
        if (outer == null) {
            res = generics;
        } else {
            LinkedHashMap<String, Type> outerGenerics;
            if (outer instanceof ParameterizedType) {
                outerGenerics = GenericsResolutionUtils.resolveGenerics(outer, new IgnoreGenericsMap((Map<? extends String, ? extends Type>)generics));
            } else {
                Class<?> outerType = GenericsUtils.resolveClass(outer, generics);
                outerGenerics = knownGenerics != null && knownGenerics.containsKey(outerType) ? new LinkedHashMap(knownGenerics.get(outerType)) : GenericsResolutionUtils.resolveRawGenerics(outerType);
            }
            for (TypeVariable<Class<?>> var : GenericsUtils.resolveClass(type, generics).getTypeParameters()) {
                outerGenerics.remove(var.getName());
            }
            if (generics instanceof EmptyGenericsMap) {
                res = outerGenerics;
            } else {
                generics.putAll(outerGenerics);
                res = generics;
            }
        }
        return res;
    }

    private static LinkedHashMap<String, Type> resolveRawGenericsChain(TypeVariable[] declaredGenerics, Map<String, Type> generics) {
        if (declaredGenerics.length == 0) {
            return EmptyGenericsMap.getInstance();
        }
        LinkedHashMap<String, Type> contextGenerics = generics == null ? new LinkedHashMap<String, Type>() : new LinkedHashMap<String, Type>(generics);
        LinkedHashMap<String, Type> res = new LinkedHashMap<String, Type>();
        ArrayList<TypeVariable> failed = new ArrayList<TypeVariable>();
        for (TypeVariable variable : declaredGenerics) {
            Class<?> resolved = null;
            try {
                resolved = GenericsResolutionUtils.resolveRawGeneric(variable, contextGenerics);
            }
            catch (UnknownGenericException ex) {
                if (ex.getGenericName().equals(variable.getName()) && ex.getGenericSource().equals(variable.getGenericDeclaration())) {
                    resolved = GenericsUtils.resolveClass(variable.getBounds()[0], contextGenerics);
                }
                failed.add(variable);
            }
            res.put(variable.getName(), resolved);
            contextGenerics.put(variable.getName(), resolved);
        }
        if (!failed.isEmpty()) {
            for (TypeVariable variable : GenericsUtils.orderVariablesForResolution(failed)) {
                Type result = GenericsResolutionUtils.resolveRawGeneric(variable, contextGenerics);
                res.put(variable.getName(), result);
                contextGenerics.put(variable.getName(), result);
            }
        }
        return res;
    }

    private static void analyzeType(Map<Class<?>, LinkedHashMap<String, Type>> generics, Class<?> type, Map<Class<?>, LinkedHashMap<String, Type>> knownGenerics, List<Class<?>> ignoreClasses) {
        Class<?> supertype = type;
        while (true) {
            for (Type iface : supertype.getGenericInterfaces()) {
                GenericsResolutionUtils.analyzeInterface(generics, knownGenerics, iface, supertype, ignoreClasses);
            }
            Class<?> next = supertype.getSuperclass();
            if (next == null || Object.class == next || ignoreClasses.contains(next)) break;
            LinkedHashMap<String, Type> nextGenerics = knownGenerics.containsKey(next) ? knownGenerics.get(next) : GenericsResolutionUtils.analyzeParent(supertype, (Map<String, Type>)generics.get(supertype));
            generics.put(next, GenericsResolutionUtils.fillOuterGenerics(next, nextGenerics, knownGenerics));
            supertype = next;
        }
    }

    private static void analyzeInterface(Map<Class<?>, LinkedHashMap<String, Type>> types, Map<Class<?>, LinkedHashMap<String, Type>> knownTypes, Type iface, Class<?> hostType, List<Class<?>> ignoreClasses) {
        Class interfaceType;
        Class clazz = interfaceType = iface instanceof ParameterizedType ? (Class)((ParameterizedType)iface).getRawType() : (Class)iface;
        if (!ignoreClasses.contains(interfaceType)) {
            if (knownTypes.containsKey(interfaceType)) {
                types.put(interfaceType, knownTypes.get(interfaceType));
            } else if (iface instanceof ParameterizedType) {
                ParameterizedType parametrization = (ParameterizedType)iface;
                LinkedHashMap<String, Type> generics = GenericsResolutionUtils.resolveGenerics(parametrization, (Map<String, Type>)types.get(hostType));
                if (types.containsKey(interfaceType)) {
                    GenericsResolutionUtils.merge(interfaceType, generics, types.get(interfaceType));
                }
                types.put(interfaceType, generics);
            } else if (interfaceType.getTypeParameters().length > 0) {
                types.put(interfaceType, GenericsResolutionUtils.resolveRawGenerics(interfaceType));
            } else if (!GROOVY_OBJECT.equals(interfaceType.getSimpleName())) {
                types.put(interfaceType, EmptyGenericsMap.getInstance());
            }
            GenericsResolutionUtils.analyzeType(types, interfaceType, knownTypes, ignoreClasses);
        }
    }

    private static void merge(Class<?> type, LinkedHashMap<String, Type> main, LinkedHashMap<String, Type> additional) {
        for (Map.Entry<String, Type> entry : additional.entrySet()) {
            Type currentValue;
            String generic = entry.getKey();
            Type value = entry.getValue();
            if (TypeUtils.isCompatible(value, currentValue = main.get(generic))) {
                main.put(generic, TypeUtils.getMoreSpecificType(value, currentValue));
                continue;
            }
            throw new IncompatibleTypesException(String.format("Interface %s appears multiple times in root class hierarchy with incompatible parametrization for generic %s: %%s and %%s", TypeToStringUtils.toStringWithNamedGenerics(type), generic), currentValue, value);
        }
    }

    private static LinkedHashMap<String, Type> analyzeParent(Class type, Map<String, Type> generics) {
        LinkedHashMap<String, Type> res = null;
        Class parent = type.getSuperclass();
        if (!type.isInterface() && parent != null && parent != Object.class && type.getGenericSuperclass() instanceof ParameterizedType) {
            res = GenericsResolutionUtils.resolveGenerics(type.getGenericSuperclass(), generics);
        } else if (parent != null && parent.getTypeParameters().length > 0) {
            res = GenericsResolutionUtils.resolveRawGenerics(parent);
        }
        return res == null ? EmptyGenericsMap.getInstance() : res;
    }
}

