/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.error;

import java.lang.reflect.Type;
import ru.vyarus.java.generics.resolver.error.GenericsException;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;
import ru.vyarus.java.generics.resolver.util.map.PrintableGenericsMap;

public class IncompatibleTypesException
extends GenericsException {
    private final Type first;
    private final Type second;

    public IncompatibleTypesException(Type first, Type second) {
        this(null, first, second);
    }

    public IncompatibleTypesException(String message, Type first, Type second) {
        super(IncompatibleTypesException.formatMessage(message, first, second));
        this.first = first;
        this.second = second;
    }

    public Type getFirst() {
        return this.first;
    }

    public Type getSecond() {
        return this.second;
    }

    private static String formatMessage(String message, Type first, Type second) {
        String msg = message == null ? "Incompatible types: %s and %s" : message;
        PrintableGenericsMap generics = new PrintableGenericsMap();
        return String.format(msg, TypeToStringUtils.toStringType(first, generics), TypeToStringUtils.toStringType(second, generics));
    }
}

