/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context.container;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;

public class ExplicitTypeVariable
implements Type {
    private final String name;
    private final TypeVariable declarationSource;
    private final Type[] bounds;

    public ExplicitTypeVariable(TypeVariable variable) {
        this.name = variable.getName();
        this.declarationSource = variable;
        this.bounds = variable.getBounds();
    }

    public ExplicitTypeVariable(String name) {
        this.name = name;
        this.declarationSource = null;
        this.bounds = new Type[]{Object.class};
    }

    public String getName() {
        return this.name;
    }

    public TypeVariable getDeclarationSource() {
        return this.declarationSource;
    }

    public Type[] getBounds() {
        return Arrays.copyOf(this.bounds, this.bounds.length);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExplicitTypeVariable)) {
            return false;
        }
        ExplicitTypeVariable that = (ExplicitTypeVariable)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.declarationSource != null ? !this.declarationSource.equals(that.declarationSource) : that.declarationSource != null) {
            return false;
        }
        return Arrays.equals(this.bounds, that.bounds);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.declarationSource != null ? this.declarationSource.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.bounds);
        return result;
    }
}

