/*
 * Decompiled with CFR 0.152.
 */
package tdl.participant.queue.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import tdl.participant.queue.connector.QueueEvent;
import tdl.participant.queue.events.ParticipantEvent;

@QueueEvent(name="roundStarted", version="0.2")
public final class RoundStartedEvent
implements ParticipantEvent {
    private final long timestampMillis;
    private final String participant;
    private final String roundId;

    @JsonCreator
    public RoundStartedEvent(@JsonProperty(value="timestampMillis") long timestampMillis, @JsonProperty(value="participant") String participant, @JsonProperty(value="roundId") String roundId) {
        this.timestampMillis = timestampMillis;
        this.participant = participant;
        this.roundId = roundId;
    }

    @Override
    public long getTimestampMillis() {
        return this.timestampMillis;
    }

    @Override
    public String getParticipant() {
        return this.participant;
    }

    public String getRoundId() {
        return this.roundId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoundStartedEvent)) {
            return false;
        }
        RoundStartedEvent other = (RoundStartedEvent)o;
        if (this.getTimestampMillis() != other.getTimestampMillis()) {
            return false;
        }
        String this$participant = this.getParticipant();
        String other$participant = other.getParticipant();
        if (this$participant == null ? other$participant != null : !this$participant.equals(other$participant)) {
            return false;
        }
        String this$roundId = this.getRoundId();
        String other$roundId = other.getRoundId();
        return !(this$roundId == null ? other$roundId != null : !this$roundId.equals(other$roundId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestampMillis = this.getTimestampMillis();
        result = result * 59 + (int)($timestampMillis >>> 32 ^ $timestampMillis);
        String $participant = this.getParticipant();
        result = result * 59 + ($participant == null ? 43 : $participant.hashCode());
        String $roundId = this.getRoundId();
        result = result * 59 + ($roundId == null ? 43 : $roundId.hashCode());
        return result;
    }

    public String toString() {
        return "RoundStartedEvent(timestampMillis=" + this.getTimestampMillis() + ", participant=" + this.getParticipant() + ", roundId=" + this.getRoundId() + ")";
    }
}

