/*
 * Decompiled with CFR 0.152.
 */
package tdl.participant.queue.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import tdl.participant.queue.connector.QueueEvent;
import tdl.participant.queue.events.ParticipantEvent;

@QueueEvent(name="challengeCompleted", version="0.2")
public final class ChallengeCompletedEvent
implements ParticipantEvent {
    private final long timestampMillis;
    private final String participant;
    private final String challengeId;
    private final int totalClockTimeMin;
    private final int totalPenaltyTimeMin;

    @JsonCreator
    public ChallengeCompletedEvent(@JsonProperty(value="timestampMillis") long timestampMillis, @JsonProperty(value="participant") String participant, @JsonProperty(value="challengeId") String challengeId, @JsonProperty(value="totalClockTimeMin") int totalClockTimeMin, @JsonProperty(value="totalPenaltyTimeMin") int totalPenaltyTimeMin) {
        this.timestampMillis = timestampMillis;
        this.participant = participant;
        this.challengeId = challengeId;
        this.totalClockTimeMin = totalClockTimeMin;
        this.totalPenaltyTimeMin = totalPenaltyTimeMin;
    }

    @Override
    public long getTimestampMillis() {
        return this.timestampMillis;
    }

    @Override
    public String getParticipant() {
        return this.participant;
    }

    public String getChallengeId() {
        return this.challengeId;
    }

    public int getTotalClockTimeMin() {
        return this.totalClockTimeMin;
    }

    public int getTotalPenaltyTimeMin() {
        return this.totalPenaltyTimeMin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChallengeCompletedEvent)) {
            return false;
        }
        ChallengeCompletedEvent other = (ChallengeCompletedEvent)o;
        if (this.getTimestampMillis() != other.getTimestampMillis()) {
            return false;
        }
        String this$participant = this.getParticipant();
        String other$participant = other.getParticipant();
        if (this$participant == null ? other$participant != null : !this$participant.equals(other$participant)) {
            return false;
        }
        String this$challengeId = this.getChallengeId();
        String other$challengeId = other.getChallengeId();
        if (this$challengeId == null ? other$challengeId != null : !this$challengeId.equals(other$challengeId)) {
            return false;
        }
        if (this.getTotalClockTimeMin() != other.getTotalClockTimeMin()) {
            return false;
        }
        return this.getTotalPenaltyTimeMin() == other.getTotalPenaltyTimeMin();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestampMillis = this.getTimestampMillis();
        result = result * 59 + (int)($timestampMillis >>> 32 ^ $timestampMillis);
        String $participant = this.getParticipant();
        result = result * 59 + ($participant == null ? 43 : $participant.hashCode());
        String $challengeId = this.getChallengeId();
        result = result * 59 + ($challengeId == null ? 43 : $challengeId.hashCode());
        result = result * 59 + this.getTotalClockTimeMin();
        result = result * 59 + this.getTotalPenaltyTimeMin();
        return result;
    }

    public String toString() {
        return "ChallengeCompletedEvent(timestampMillis=" + this.getTimestampMillis() + ", participant=" + this.getParticipant() + ", challengeId=" + this.getChallengeId() + ", totalClockTimeMin=" + this.getTotalClockTimeMin() + ", totalPenaltyTimeMin=" + this.getTotalPenaltyTimeMin() + ")";
    }
}

