/*
 * Decompiled with CFR 0.152.
 */
package tdl.participant.queue.connector;

import java.util.HashMap;
import java.util.Map;
import tdl.participant.queue.connector.EventConsumer;
import tdl.participant.queue.connector.EventInspector;
import tdl.participant.queue.connector.EventProcessingException;
import tdl.participant.queue.connector.HandleRule;
import tdl.participant.queue.connector.QueueEvent;

public class QueueEventHandlers {
    private EventInspector beforeEventInspector = (eventName, eventVersion, eventObject) -> {};
    private Map<String, HandleRule> handleMap = new HashMap<String, HandleRule>();
    private EventInspector afterEventInspector = (eventName, eventVersion, eventObject) -> {};

    public void before(EventInspector beforeEventInspector) {
        this.beforeEventInspector = beforeEventInspector;
    }

    public <T> void on(Class<T> type, EventConsumer<T> handler) throws EventProcessingException {
        QueueEvent annotation = type.getAnnotation(QueueEvent.class);
        if (annotation == null) {
            throw new EventProcessingException(type.getClass() + " not a QueueEvent");
        }
        this.handleMap.put(QueueEventHandlers.getKey(annotation.name(), annotation.version()), new HandleRule<T>(type, handler));
    }

    public void after(EventInspector afterEventInspector) {
        this.afterEventInspector = afterEventInspector;
    }

    public EventInspector getBeforeEventInspector() {
        return this.beforeEventInspector;
    }

    public boolean canHandle(String eventName, String eventVersion) {
        String eventKey = QueueEventHandlers.getKey(eventName, eventVersion);
        return this.handleMap.containsKey(eventKey);
    }

    public HandleRule getHandleRuleFor(String eventName, String eventVersion) {
        String eventKey = QueueEventHandlers.getKey(eventName, eventVersion);
        return this.handleMap.get(eventKey);
    }

    public EventInspector getAfterEventInspector() {
        return this.afterEventInspector;
    }

    private static String getKey(String eventName, String eventVersion) {
        return eventName + "-" + eventVersion;
    }
}

