/*
 * Decompiled with CFR 0.152.
 */
package pro.streem.sdk.internal.logging;

import android.app.Application;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.jakewharton.rxrelay2.PublishRelay;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.streem.sdk.internal.logging.CentralizedLogger;
import pro.streem.sdk.internal.logging.ErrorObject;
import pro.streem.sdk.internal.logging.Logject;
import pro.streem.sdk.internal.logging.LogjectLevel;
import pro.streem.sdk.internal.logging.ScribeApi;
import pro.streem.sdk.internal.logging.StreemLogUtilsKt;
import pro.streem.sdk.internal.util.TimeProvider;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J$\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\nH\u0016J$\u0010 \u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0016J.\u0010\"\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lpro/streem/sdk/internal/logging/ScribeLogger;", "Lpro/streem/sdk/internal/logging/CentralizedLogger;", "scribeApi", "Lpro/streem/sdk/internal/logging/ScribeApi;", "timeProvider", "Lpro/streem/sdk/internal/util/TimeProvider;", "application", "Landroid/app/Application;", "(Lpro/streem/sdk/internal/logging/ScribeApi;Lpro/streem/sdk/internal/util/TimeProvider;Landroid/app/Application;)V", "appName", "", "context", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "disposable", "Lio/reactivex/disposables/Disposable;", "logMessages", "Lcom/jakewharton/rxrelay2/PublishRelay;", "Lpro/streem/sdk/internal/logging/Logject;", "kotlin.jvm.PlatformType", "addOrUpdateContext", "", "key", "value", "dispose", "logError", "tag", "msg", "throwable", "", "logInfo", "logWarn", "removeContext", "sendMessage", "logLevel", "Lpro/streem/sdk/internal/logging/LogjectLevel;", "Companion", "platform-client_release"})
public final class ScribeLogger
implements CentralizedLogger {
    private Disposable disposable;
    private final PublishRelay<Logject> logMessages;
    private final HashMap<String, Object> context;
    private final String appName;
    private final ScribeApi scribeApi;
    private final TimeProvider timeProvider;
    private final Application application;
    private static final String TAG;
    @NotNull
    public static final String SERVICE = "android-sdk";
    @NotNull
    private static final LogjectLevel logLevelInfo;
    @NotNull
    private static final LogjectLevel logLevelWarning;
    @NotNull
    private static final LogjectLevel logLevelError;
    public static final Companion Companion;

    @Override
    public void dispose() {
        block0: {
            Disposable disposable = this.disposable;
            if (disposable == null) break block0;
            disposable.dispose();
        }
    }

    @Override
    public void addOrUpdateContext(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        ((Map)this.context).put(key, value);
    }

    @Override
    public void removeContext(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.context.remove(key);
    }

    @Override
    public void logInfo(@Nullable String tag, @NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Log.d((String)tag, (String)msg);
        ScribeLogger.sendMessage$default(this, tag, msg, logLevelInfo, null, 8, null);
    }

    @Override
    public void logWarn(@Nullable String tag, @NotNull String msg, @Nullable Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (throwable != null) {
            Log.w((String)tag, (String)msg, (Throwable)throwable);
        } else {
            Log.w((String)tag, (String)msg);
        }
        this.sendMessage(tag, msg, logLevelWarning, throwable);
    }

    @Override
    public void logError(@Nullable String tag, @NotNull String msg, @Nullable Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (throwable != null) {
            Log.e((String)tag, (String)msg, (Throwable)throwable);
        } else {
            Log.e((String)tag, (String)msg);
        }
        this.sendMessage(tag, msg, logLevelError, throwable);
    }

    private final void sendMessage(String tag, String msg, LogjectLevel logLevel, Throwable throwable) {
        Date now = new Date(this.timeProvider.getCurrentTimeMillis());
        String string = StreemLogUtilsKt.toLocalTime24HourString(now);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"now.toLocalTime24HourString()");
        String string2 = StreemLogUtilsKt.toUtcIso8601String(now);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"now.toUtcIso8601String()");
        Throwable throwable2 = throwable;
        Map map = this.context;
        List<ErrorObject> list = throwable2 != null ? StreemLogUtilsKt.toErrorList(throwable2) : null;
        String string3 = tag;
        LogjectLevel logjectLevel = logLevel;
        String string4 = string2;
        String string5 = string;
        String string6 = msg;
        this.logMessages.accept((Object)new Logject(SERVICE, this.appName, string5, string4, logjectLevel, string6, string3, list, map));
    }

    static /* synthetic */ void sendMessage$default(ScribeLogger scribeLogger, String string, String string2, LogjectLevel logjectLevel, Throwable throwable, int n, Object object) {
        if ((n & 8) != 0) {
            throwable = null;
        }
        scribeLogger.sendMessage(string, string2, logjectLevel, throwable);
    }

    public ScribeLogger(@NotNull ScribeApi scribeApi, @NotNull TimeProvider timeProvider, @NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)scribeApi, (String)"scribeApi");
        Intrinsics.checkParameterIsNotNull((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.scribeApi = scribeApi;
        this.timeProvider = timeProvider;
        this.application = application;
        PublishRelay publishRelay = PublishRelay.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishRelay, (String)"PublishRelay.create<Logject>()");
        this.logMessages = publishRelay;
        this.context = new HashMap();
        this.appName = ((Object)this.application.getApplicationInfo().loadLabel(this.application.getPackageManager())).toString();
        Log.d((String)TAG, (String)"Subscribing to logMessages");
        this.disposable = this.logMessages.observeOn(Schedulers.single()).flatMapCompletable((Function)new Function<Logject, CompletableSource>(){

            public final Completable apply(final @NotNull Logject msg) {
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                return scribeApi.recordLog(msg).doOnError((Consumer)new Consumer<Throwable>(){

                    public final void accept(Throwable it) {
                        Log.e((String)TAG, (String)("Error recording log message: " + msg), (Throwable)it);
                    }
                }).onErrorComplete();
            }
        }).subscribe((Action)2.INSTANCE, (Consumer)3.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        TAG = Reflection.getOrCreateKotlinClass(ScribeLogger.class).getSimpleName();
        logLevelInfo = new LogjectLevel("INFO", "\ud83d\udd35", "lightblue");
        logLevelWarning = new LogjectLevel("WARN", "\u26a0", "orange");
        logLevelError = new LogjectLevel("ERROR", "\u203c", "red");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\nR\u001c\u0010\u000e\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0011"}, d2={"Lpro/streem/sdk/internal/logging/ScribeLogger$Companion;", "", "()V", "SERVICE", "", "TAG", "logLevelError", "Lpro/streem/sdk/internal/logging/LogjectLevel;", "logLevelError$annotations", "getLogLevelError", "()Lpro/streem/sdk/internal/logging/LogjectLevel;", "logLevelInfo", "logLevelInfo$annotations", "getLogLevelInfo", "logLevelWarning", "logLevelWarning$annotations", "getLogLevelWarning", "platform-client_release"})
    public static final class Companion {
        @VisibleForTesting
        public static /* synthetic */ void logLevelInfo$annotations() {
        }

        @NotNull
        public final LogjectLevel getLogLevelInfo() {
            return logLevelInfo;
        }

        @VisibleForTesting
        public static /* synthetic */ void logLevelWarning$annotations() {
        }

        @NotNull
        public final LogjectLevel getLogLevelWarning() {
            return logLevelWarning;
        }

        @VisibleForTesting
        public static /* synthetic */ void logLevelError$annotations() {
        }

        @NotNull
        public final LogjectLevel getLogLevelError() {
            return logLevelError;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

