/*
 * Decompiled with CFR 0.152.
 */
package pro.streem.sdk.internal.logging;

import android.os.Build;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.streem.sdk.internal.logging.CentralizedLogger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0012\n\u0002\u0010\u0003\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000eJ*\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00010\u00010\u00102\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fJ.\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00102\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\fJ2\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u00100\u00102\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u0010J\"\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fJ\r\u0010\u001d\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u001eJ+\u0010\u001f\u001a\u0004\u0018\u00010\n2\b\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\f2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010$J\u001f\u0010%\u001a\u0004\u0018\u00010\n2\b\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\f\u00a2\u0006\u0002\u0010&J+\u0010'\u001a\u0004\u0018\u00010\n2\b\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\f2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010$J\u0015\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010)R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006+"}, d2={"Lpro/streem/sdk/internal/logging/StreemLog;", "", "()V", "logger", "Lpro/streem/sdk/internal/logging/CentralizedLogger;", "getLogger", "()Lpro/streem/sdk/internal/logging/CentralizedLogger;", "setLogger", "(Lpro/streem/sdk/internal/logging/CentralizedLogger;)V", "addOrUpdateContext", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlin/Unit;", "createDeviceInfoMap", "", "kotlin.jvm.PlatformType", "versionName", "deviceSid", "createRoomParticipantsMap", "localUserId", "localDeviceId", "remoteUserId", "createSessionConfigMap", "sessionConfigMap", "createUserInfoMap", "companyId", "userId", "dispose", "()Lkotlin/Unit;", "logError", "tag", "msg", "throwable", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)Lkotlin/Unit;", "logInfo", "(Ljava/lang/String;Ljava/lang/String;)Lkotlin/Unit;", "logWarn", "removeContext", "(Ljava/lang/String;)Lkotlin/Unit;", "Context", "platform-client_release"})
public final class StreemLog {
    @Nullable
    private static CentralizedLogger logger;
    public static final StreemLog INSTANCE;

    @Nullable
    public final CentralizedLogger getLogger() {
        return logger;
    }

    public final void setLogger(@Nullable CentralizedLogger centralizedLogger) {
        logger = centralizedLogger;
    }

    @Nullable
    public final Unit addOrUpdateContext(@NotNull String key, @NotNull Object value) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        CentralizedLogger centralizedLogger = logger;
        if (centralizedLogger != null) {
            centralizedLogger.addOrUpdateContext(key, value);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final Unit removeContext(@NotNull String key) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        CentralizedLogger centralizedLogger = logger;
        if (centralizedLogger != null) {
            centralizedLogger.removeContext(key);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final Unit logInfo(@Nullable String tag, @NotNull String msg) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        CentralizedLogger centralizedLogger = logger;
        if (centralizedLogger != null) {
            centralizedLogger.logInfo(tag, msg);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final Unit logWarn(@Nullable String tag, @NotNull String msg, @Nullable Throwable throwable) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        CentralizedLogger centralizedLogger = logger;
        if (centralizedLogger != null) {
            centralizedLogger.logWarn(tag, msg, throwable);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static /* synthetic */ Unit logWarn$default(StreemLog streemLog, String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        return streemLog.logWarn(string, string2, throwable);
    }

    @Nullable
    public final Unit logError(@Nullable String tag, @NotNull String msg, @Nullable Throwable throwable) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        CentralizedLogger centralizedLogger = logger;
        if (centralizedLogger != null) {
            centralizedLogger.logError(tag, msg, throwable);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static /* synthetic */ Unit logError$default(StreemLog streemLog, String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        return streemLog.logError(string, string2, throwable);
    }

    @Nullable
    public final Unit dispose() {
        Unit unit;
        CentralizedLogger centralizedLogger = logger;
        if (centralizedLogger != null) {
            centralizedLogger.dispose();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @NotNull
    public final Map<String, String> createUserInfoMap(@NotNull String companyId, @NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)companyId, (String)"companyId");
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"companyCode", (Object)companyId), TuplesKt.to((Object)"id", (Object)userId)});
    }

    @NotNull
    public final Map<String, Object> createDeviceInfoMap(@NotNull String versionName, @NotNull String deviceSid) {
        Intrinsics.checkParameterIsNotNull((Object)versionName, (String)"versionName");
        Intrinsics.checkParameterIsNotNull((Object)deviceSid, (String)"deviceSid");
        Pair[] pairArray = new Pair[10];
        pairArray[0] = TuplesKt.to((Object)"platform", (Object)"android");
        pairArray[1] = TuplesKt.to((Object)"appVersion", (Object)versionName);
        pairArray[2] = TuplesKt.to((Object)"androidVersion", (Object)Build.VERSION.RELEASE);
        pairArray[3] = TuplesKt.to((Object)"androidSdkLevel", (Object)Build.VERSION.SDK_INT);
        pairArray[4] = TuplesKt.to((Object)"manufacturer", (Object)Build.MANUFACTURER);
        pairArray[5] = TuplesKt.to((Object)"model", (Object)Build.MODEL);
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)timeZone, (String)"TimeZone.getDefault()");
        pairArray[6] = TuplesKt.to((Object)"timezone", (Object)timeZone.getDisplayName());
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        pairArray[7] = TuplesKt.to((Object)"deviceCountry", (Object)locale.getCountry());
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.getDefault()");
        pairArray[8] = TuplesKt.to((Object)"deviceLocale", (Object)locale2.getDisplayName());
        pairArray[9] = TuplesKt.to((Object)"sid", (Object)deviceSid);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Map<String, Map<String, Object>> createSessionConfigMap(@NotNull Map<String, ? extends Object> sessionConfigMap) {
        Intrinsics.checkParameterIsNotNull(sessionConfigMap, (String)"sessionConfigMap");
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"config", sessionConfigMap));
    }

    @NotNull
    public final Map<String, String> createRoomParticipantsMap(@NotNull String localUserId, @NotNull String localDeviceId, @Nullable String remoteUserId) {
        Intrinsics.checkParameterIsNotNull((Object)localUserId, (String)"localUserId");
        Intrinsics.checkParameterIsNotNull((Object)localDeviceId, (String)"localDeviceId");
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"localUserId", (Object)localUserId), TuplesKt.to((Object)"localDeviceId", (Object)localDeviceId), TuplesKt.to((Object)"remoteUserId", (Object)remoteUserId)});
    }

    private StreemLog() {
    }

    static {
        StreemLog streemLog;
        INSTANCE = streemLog = new StreemLog();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lpro/streem/sdk/internal/logging/StreemLog$Context;", "", "()V", "ANDROID_SDK_LEVEL", "", "ANDROID_VERSION", "APP_VERSION", "AUDIO_TRACK", "COMPANY_CODE", "CONFIG", "DEVICE_COUNTRY", "DEVICE_INFO", "DEVICE_LOCALE", "ID", "LABEL", "LOCAL_DEVICE_ID", "LOCAL_USER_ID", "MANUFACTURER", "MODEL", "PLATFORM", "REMOTE_USER_ID", "ROOM_ID", "ROOM_PARTICIPANTS", "SESSION", "SID", "TIMEZONE", "TOOLS", "USER", "VIDEO_TRACK", "platform-client_release"})
    public static final class Context {
        @NotNull
        public static final String USER = "user";
        @NotNull
        public static final String DEVICE_INFO = "deviceInfo";
        @NotNull
        public static final String ROOM_PARTICIPANTS = "roomParticipants";
        @NotNull
        public static final String ROOM_ID = "roomId";
        @NotNull
        public static final String SESSION = "session";
        @NotNull
        public static final String COMPANY_CODE = "companyCode";
        @NotNull
        public static final String ID = "id";
        @NotNull
        public static final String PLATFORM = "platform";
        @NotNull
        public static final String APP_VERSION = "appVersion";
        @NotNull
        public static final String ANDROID_VERSION = "androidVersion";
        @NotNull
        public static final String ANDROID_SDK_LEVEL = "androidSdkLevel";
        @NotNull
        public static final String MANUFACTURER = "manufacturer";
        @NotNull
        public static final String MODEL = "model";
        @NotNull
        public static final String TIMEZONE = "timezone";
        @NotNull
        public static final String DEVICE_COUNTRY = "deviceCountry";
        @NotNull
        public static final String DEVICE_LOCALE = "deviceLocale";
        @NotNull
        public static final String SID = "sid";
        @NotNull
        public static final String LOCAL_USER_ID = "localUserId";
        @NotNull
        public static final String LOCAL_DEVICE_ID = "localDeviceId";
        @NotNull
        public static final String REMOTE_USER_ID = "remoteUserId";
        @NotNull
        public static final String CONFIG = "config";
        @NotNull
        public static final String LABEL = "label";
        @NotNull
        public static final String AUDIO_TRACK = "audioTrack";
        @NotNull
        public static final String VIDEO_TRACK = "videoTrack";
        @NotNull
        public static final String TOOLS = "tools";
        public static final Context INSTANCE;

        private Context() {
        }

        static {
            Context context;
            INSTANCE = context = new Context();
        }
    }
}

